/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenHandler;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenStore;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthResourceServer;
import org.iplass.mtp.impl.auth.oauth.OAuthClientService;
import org.iplass.mtp.impl.auth.oauth.OAuthResourceServerService;
import org.iplass.mtp.impl.auth.oauth.OAuthRuntimeException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthClientCredentialHandler
extends AuthTokenHandler {
    private static Logger logger = LoggerFactory.getLogger((String)"mtp.auth.oauth");
    public static final String TYPE_CLIENT = "OC";
    public static final String TYPE_RESOURCE_SERVER = "ORS";
    public static final String TYPE_POST_FIX_OLD = "$OLD";
    private AuthTokenStore oldCredentialStore;
    private int oldCredentialValidDays;

    public int getOldCredentialValidDays() {
        return this.oldCredentialValidDays;
    }

    public void setOldCredentialValidDays(int oldCredentialValidDays) {
        this.oldCredentialValidDays = oldCredentialValidDays;
    }

    private String metaDataId(String clientId) {
        if (TYPE_CLIENT.equals(this.getType())) {
            MetaOAuthClient.OAuthClientRuntime c = (MetaOAuthClient.OAuthClientRuntime)((OAuthClientService)ServiceRegistry.getRegistry().getService(OAuthClientService.class)).getRuntimeByName(clientId);
            if (c == null) {
                return null;
            }
            return c.getMetaData().getId();
        }
        if (TYPE_RESOURCE_SERVER.equals(this.getType())) {
            MetaOAuthResourceServer.OAuthResourceServerRuntime r = (MetaOAuthResourceServer.OAuthResourceServerRuntime)((OAuthResourceServerService)ServiceRegistry.getRegistry().getService(OAuthResourceServerService.class)).getRuntimeByName(clientId);
            if (r == null) {
                return null;
            }
            return r.getMetaData().getId();
        }
        return null;
    }

    public Credential generateCredential(String clientId) {
        AuthToken current;
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        String clientMetaDataId = this.metaDataId(clientId);
        if (clientMetaDataId == null) {
            throw new IllegalArgumentException("invalid clientId or clientType:" + clientId + ", " + this.getType());
        }
        if (this.oldCredentialValidDays > 0 && (current = this.authTokenStore().getBySeries(tenantId, this.getType(), clientMetaDataId)) != null) {
            List ats = this.oldCredentialStore.getByOwner(tenantId, this.getType() + TYPE_POST_FIX_OLD, clientMetaDataId);
            int nextIndex = this.nextIndex(ats);
            current.setSeries(current.getSeries() + "$" + nextIndex);
            current.setStartDate(new Timestamp(System.currentTimeMillis()));
            current.setType(current.getType() + TYPE_POST_FIX_OLD);
            this.oldCredentialStore.create(current);
        }
        this.authTokenStore().deleteBySeries(tenantId, this.getType(), clientMetaDataId);
        AuthToken at = this.newAuthToken(clientMetaDataId, null, new OAuthClientCredentialInfo(this.getType()));
        this.authTokenStore().create(at);
        if (logger.isInfoEnabled()) {
            logger.info(clientId + ":" + this.getType() + ",generateClientSecret,success");
        }
        return new IdPasswordCredential(clientId, at.getToken());
    }

    private int nextIndex(List<AuthToken> ats) {
        int max = -1;
        if (ats != null) {
            for (AuthToken at : ats) {
                String series = at.getSeries();
                int i = Integer.parseInt(series.substring(series.lastIndexOf(36) + 1));
                if (max >= i) continue;
                max = i;
            }
        }
        return max + 1;
    }

    public boolean validateCredential(Credential cre, String clientId) {
        List ats;
        if (!(cre instanceof IdPasswordCredential)) {
            throw new OAuthRuntimeException("Currently, only IdPasswordCredential is supported.");
        }
        if (!cre.getId().equals(clientId)) {
            if (logger.isWarnEnabled()) {
                logger.warn(clientId + ",clientValidate,fail");
            }
            return false;
        }
        String clientMetaDataId = this.metaDataId(clientId);
        if (clientMetaDataId == null) {
            if (logger.isWarnEnabled()) {
                logger.warn(clientId + ",clientValidate,fail");
            }
            return false;
        }
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        AuthToken stToken = this.authTokenStore().getBySeries(tenantId, this.getType(), clientMetaDataId);
        if (stToken != null && this.checkTokenValid(((IdPasswordCredential)cre).getPassword(), stToken)) {
            return true;
        }
        if (this.oldCredentialValidDays > 0 && (ats = this.oldCredentialStore.getByOwner(tenantId, this.getType() + TYPE_POST_FIX_OLD, clientMetaDataId)) != null) {
            for (AuthToken at : ats) {
                if (at.getStartDate().getTime() + TimeUnit.DAYS.toMillis(this.oldCredentialValidDays) <= System.currentTimeMillis() || !this.checkTokenValid(((IdPasswordCredential)cre).getPassword(), at)) continue;
                return true;
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn(clientId + ",clientValidate,fail");
        }
        return false;
    }

    public void deleteOldCredential(String clientId) {
        String clientMetaDataId = this.metaDataId(clientId);
        if (clientMetaDataId == null) {
            throw new IllegalArgumentException("invalid clientId or clientType:" + clientId + ", " + this.getType());
        }
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        this.oldCredentialStore.delete(tenantId, this.getType() + TYPE_POST_FIX_OLD, clientMetaDataId);
    }

    public void inited(AuthTokenService service, Config config) {
        super.inited(service, config);
        this.setVisible(false);
        this.oldCredentialStore = service.getStore(this.getStore());
    }

    public AuthTokenInfo toAuthTokenInfo(AuthToken authToken) {
        return null;
    }

    protected Serializable createDetails(String seriesString, String tokenString, String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        return null;
    }

    public Credential toCredential(AuthToken newToken) {
        return new IdPasswordCredential(newToken.getOwnerId(), newToken.getToken());
    }

    public String newSeriesString(String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        return userUniqueId;
    }

    static class OAuthClientCredentialInfo
    implements AuthTokenInfo {
        private String type;

        OAuthClientCredentialInfo(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getKey() {
            return null;
        }

        public String getDescription() {
            return null;
        }
    }
}

