/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.code;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.util.StringUtil;

public class AuthorizationRequest
implements Serializable {
    private static final long serialVersionUID = -3518685489891704249L;
    private String requestId = StringUtil.randomToken();
    private String authorizationServerId;
    private String clientId;
    private String redirectUri;
    private List<String> responseTypes;
    private List<String> scopes;
    private String state;
    private String responseMode;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String nonce;
    private List<String> prompt;
    private Long maxAge;
    private User user;
    private long authTime;

    public AuthorizationRequest(String authorizationServerId, String clientId, String redirectUri) {
        this.authorizationServerId = authorizationServerId;
        this.clientId = clientId;
        this.redirectUri = redirectUri;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public long getAuthTime() {
        return this.authTime;
    }

    public void setAuthTime(long authTime) {
        this.authTime = authTime;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public List<String> getPrompt() {
        return this.prompt;
    }

    public void setPrompt(List<String> prompt) {
        this.prompt = prompt;
    }

    public void addPrompts(String ... prompt) {
        if (prompt != null) {
            if (this.prompt == null) {
                this.prompt = new ArrayList<String>();
            }
            for (String p : prompt) {
                this.prompt.add(p);
            }
        }
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Long maxAge) {
        this.maxAge = maxAge;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getAuthorizationServerId() {
        return this.authorizationServerId;
    }

    public void setAuthorizationServerId(String authorizationServerId) {
        this.authorizationServerId = authorizationServerId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public List<String> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<String> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public void addResponseTypes(String ... responseType) {
        if (responseType != null) {
            if (this.responseTypes == null) {
                this.responseTypes = new ArrayList<String>();
            }
            for (String rt : responseType) {
                this.responseTypes.add(rt);
            }
        }
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public void addScopes(String ... scope) {
        if (scope != null) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String s : scope) {
                this.scopes.add(s);
            }
        }
    }

    public boolean hasPrompt(String p) {
        if (this.prompt == null) {
            return false;
        }
        return this.prompt.contains(p);
    }
}

