/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.rdb.connection.ResourceHolder;
import org.iplass.mtp.impl.web.RequestPath;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(DispatcherFilter.class);
    private static Logger fatalLogger = LoggerFactory.getLogger((String)"mtp.fatal");
    private TenantContextService tenantContextService;
    private ServletContext servletContext;
    private ActionMappingService amService;
    private WebFrontendService webFrontendService;

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        this.tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
        this.servletContext = config.getServletContext();
        this.amService = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
        this.webFrontendService = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        RequestPath path = new RequestPath(req, this.webFrontendService);
        if (!path.isValid()) {
            res.sendError(404);
            return;
        }
        ResourceHolder.init();
        try {
            if (path.getPathType() == RequestPath.PathType.UNKNOWN) {
                if (logger.isTraceEnabled()) {
                    logger.trace("excluded URL:" + req.getRequestURI());
                }
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
            req.setCharacterEncoding("utf-8");
            res.setCharacterEncoding("utf-8");
            TenantContext tc = this.getTenantContext(path.getTenantUrl());
            if (tc == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("can not determine tenant.URL=" + req.getServletPath());
                }
                res.sendError(404);
                return;
            }
            try {
                ExecuteContext.initContext((ExecuteContext)new ExecuteContext(tc));
                if (logger.isDebugEnabled()) {
                    logger.debug("do " + req.getRequestURL().toString() + " " + req.getMethod());
                }
                switch (path.getPathType()) {
                    case REJECT: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("reject URL:" + req.getRequestURI());
                        }
                        res.sendError(404);
                        return;
                    }
                    case REST: {
                        req.setAttribute("mtp.requestPath", (Object)path);
                        this.servletContext.getRequestDispatcher(path.getTargetPath()).forward((ServletRequest)req, (ServletResponse)res);
                        return;
                    }
                    case THROUGH: {
                        req.setAttribute("mtp.requestPath", (Object)path);
                        chain.doFilter((ServletRequest)req, (ServletResponse)res);
                        return;
                    }
                    case ACTION: {
                        this.doAction(path, req, res, chain);
                        return;
                    }
                }
                return;
            }
            finally {
                ExecuteContext.finContext();
            }
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                fatalLogger.error("Exception occurred while processing URI:" + req.getRequestURI() + " " + e.getMessage(), e);
            } else {
                logger.error("Exception occurred while processing URI:" + req.getRequestURI() + " " + e.getMessage(), e);
            }
            try {
                if (res.isCommitted()) return;
                res.sendError(500);
                return;
            }
            catch (Exception e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
                return;
            }
        }
        finally {
            ResourceHolder.fin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(RequestPath path, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        Tenant tenant;
        String menuUrl;
        String actionPath;
        if (WebUtil.isDirectAccess(req)) {
            logger.debug("process as direct access mode. port={}", (Object)req.getServerPort());
        }
        if ((actionPath = path.getTargetPath(true)).length() == 0 && !StringUtil.isEmpty((String)(menuUrl = WebUtil.getTenantWebInfo(tenant = ExecuteContext.getCurrentContext().getCurrentTenant()).getHomeUrl())) && !menuUrl.equals("/")) {
            String redirectPath = menuUrl.startsWith("/") ? path.getTenantContextPath(req) + menuUrl : path.getTenantContextPath(req) + "/" + menuUrl;
            logger.debug("redirects to top URL.RedirectURL=" + redirectPath);
            res.sendRedirect(redirectPath);
            return;
        }
        WebRequestStack requestStack = new WebRequestStack(path, this.servletContext, req, res);
        try {
            MetaActionMapping.ActionMappingRuntime actionMapping = this.amService.getByPathHierarchy(actionPath);
            if (actionMapping == null && this.webFrontendService.getWelcomeAction() != null && (actionPath.length() == 0 || actionPath.endsWith("/"))) {
                for (String wa : this.webFrontendService.getWelcomeAction()) {
                    actionMapping = this.amService.getByPathHierarchy(actionPath + wa);
                    if (actionMapping == null) continue;
                    break;
                }
            }
            if (actionMapping != null) {
                logger.debug("call actionMapping:" + actionMapping.getMetaData().getName());
                actionMapping.executeCommand(requestStack);
            } else {
                res.sendError(404);
            }
        }
        finally {
            if (requestStack != null) {
                requestStack.finallyProcess();
            }
        }
    }

    private TenantContext getTenantContext(String value) {
        TenantContext context = this.tenantContextService.getTenantContext(value);
        return context;
    }
}

