/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.iplass.mtp.impl.web.ContentDispositionPolicy;
import org.iplass.mtp.impl.web.ErrorUrlSelector;
import org.iplass.mtp.impl.web.LoginUrlSelector;
import org.iplass.mtp.impl.web.fileupload.FileScanner;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.web.actionmapping.definition.ClientCacheType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFrontendService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(WebFrontendService.class);
    private String tempFileDir;
    private String staticContentPath;
    private String defaultContentType;
    private long maxUploadFileSize;
    private ClientCacheType defaultClientCacheType;
    private Pattern excludePathes;
    private Pattern throughPathes;
    private List<String> restPath;
    private Pattern acceptPathes;
    private Pattern rejectPathes;
    private String logoutUrl;
    private ErrorUrlSelector errorUrlSelector;
    private LoginUrlSelector loginUrlSelector;
    private List<ContentDispositionPolicy> contentDispositionPolicies;
    private FileScanner uploadFileScanner;
    private boolean isExecMagicByteCheck;
    private String directAccessPort;
    private int transactionTokenMaxSize = 50;
    private List<String> welcomeAction;
    private boolean redirectAfterLogin = true;
    private boolean tenantAsDomain;
    private String fixedTenant;

    public boolean isAcceptPathes(String path) {
        boolean ret;
        boolean bl = ret = this.getAcceptPathes() == null || this.getAcceptPathes().matcher(path).matches();
        if (this.getRejectPathes() != null) {
            ret = ret && !this.getRejectPathes().matcher(path).matches();
        }
        return ret;
    }

    public boolean isExcludePath(String path) {
        return this.getExcluePathes() != null && this.getExcluePathes().matcher(path).matches();
    }

    public boolean isThroughPath(String path) {
        return this.getThroughPathes() != null && this.getThroughPathes().matcher(path).matches();
    }

    public boolean isRestPath(String path) {
        if (this.restPath != null) {
            for (String rp : this.restPath) {
                if (!path.startsWith(rp)) continue;
                return true;
            }
        }
        return false;
    }

    public Pattern getAcceptPathes() {
        return this.acceptPathes;
    }

    public Pattern getRejectPathes() {
        return this.rejectPathes;
    }

    public Pattern getThroughPathes() {
        return this.throughPathes;
    }

    public String getFixedTenant() {
        return this.fixedTenant;
    }

    public boolean isTenantAsDomain() {
        return this.tenantAsDomain;
    }

    public boolean isRedirectAfterLogin() {
        return this.redirectAfterLogin;
    }

    public List<String> getWelcomeAction() {
        return this.welcomeAction;
    }

    public int getTransactionTokenMaxSize() {
        return this.transactionTokenMaxSize;
    }

    public boolean isExecMagicByteCheck() {
        return this.isExecMagicByteCheck;
    }

    public FileScanner getUploadFileScanner() {
        return this.uploadFileScanner;
    }

    public LoginUrlSelector getLoginUrlSelector() {
        return this.loginUrlSelector;
    }

    public ErrorUrlSelector getErrorUrlSelector() {
        return this.errorUrlSelector;
    }

    public String getTempFileDir() {
        return this.tempFileDir;
    }

    public String getStaticContentPath() {
        return this.staticContentPath;
    }

    public void destroy() {
    }

    public void init(Config config) {
        List throughPathList;
        List exclude;
        List reject;
        String maxUploadFileSize;
        this.tempFileDir = config.getValue("tempFileDir");
        if (this.tempFileDir != null) {
            File tFile = new File(this.tempFileDir);
            if (!tFile.exists()) {
                logger.debug("tempFileDir not exist:" + tFile.getAbsolutePath());
                try {
                    if (!tFile.mkdirs()) {
                        throw new ServiceConfigrationException("tempFileDir create failed:" + tFile.getAbsolutePath());
                    }
                    logger.info("create tempFileDir:" + tFile.getAbsolutePath());
                    tFile.setReadable(true, false);
                    tFile.setWritable(true, false);
                    tFile.setExecutable(true, false);
                }
                catch (SecurityException e) {
                    throw new ServiceConfigrationException("tempFileDir create failed:" + tFile.getAbsolutePath());
                }
            } else {
                logger.debug("tempFileDir is existed:" + tFile.getAbsolutePath());
            }
        } else {
            logger.debug("tempFileDir is undefined");
        }
        this.staticContentPath = config.getValue("staticContentPath");
        String defaultContentType = config.getValue("defaultContentType");
        if (defaultContentType == null) {
            defaultContentType = "text/html; charset=utf-8";
        }
        this.defaultContentType = defaultContentType;
        String defaultClientCacheType = config.getValue("defaultClientCacheType");
        if (defaultClientCacheType != null) {
            if (defaultClientCacheType.equals("NO_CACHE")) {
                this.defaultClientCacheType = ClientCacheType.NO_CACHE;
            } else if (defaultClientCacheType.equals("CACHE")) {
                this.defaultClientCacheType = ClientCacheType.CACHE;
            } else {
                throw new ServiceConfigrationException("defaultClientCacheType incorrect:" + defaultClientCacheType);
            }
        }
        this.maxUploadFileSize = (maxUploadFileSize = config.getValue("maxUploadFileSize")) != null ? Long.parseLong(maxUploadFileSize) : -1L;
        this.errorUrlSelector = (ErrorUrlSelector)config.getBean("errorUrlSelector");
        this.loginUrlSelector = (LoginUrlSelector)config.getBean("loginUrlSelector");
        List accept = config.getValues("acceptPath");
        if (accept != null && accept.size() > 0) {
            this.acceptPathes = Pattern.compile(String.join((CharSequence)"|", accept));
        }
        if ((reject = config.getValues("rejectPath")) != null && reject.size() > 0) {
            this.rejectPathes = Pattern.compile(String.join((CharSequence)"|", reject));
        }
        if ((exclude = config.getValues("excludePath")) != null && exclude.size() > 0) {
            this.excludePathes = Pattern.compile(String.join((CharSequence)"|", exclude));
        }
        if ((throughPathList = config.getValues("throughPath")) != null && throughPathList.size() > 0) {
            this.throughPathes = Pattern.compile(String.join((CharSequence)"|", throughPathList));
        }
        this.restPath = config.getValues("restPath");
        this.logoutUrl = config.getValue("logoutUrl");
        if (this.logoutUrl == null || this.logoutUrl.length() == 0) {
            throw new ServiceConfigrationException("\u30ed\u30b0\u30a2\u30a6\u30c8\u306eURL\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        this.contentDispositionPolicies = config.getBeans("contentDispositionPolicy");
        this.uploadFileScanner = (FileScanner)config.getBean("uploadFileScanner");
        this.isExecMagicByteCheck = Boolean.valueOf(config.getValue("isExecMagicByteCheck"));
        this.directAccessPort = config.getValue("directAccessPort");
        if (config.getValue("transactionTokenMaxSize") != null) {
            this.transactionTokenMaxSize = Integer.parseInt(config.getValue("transactionTokenMaxSize"));
        }
        this.welcomeAction = config.getValues("welcomeAction");
        if (config.getValue("redirectAfterLogin") != null) {
            this.redirectAfterLogin = Boolean.valueOf(config.getValue("redirectAfterLogin"));
        }
        if (config.getValue("tenantAsDomain") != null) {
            this.tenantAsDomain = Boolean.valueOf(config.getValue("tenantAsDomain"));
        }
        this.fixedTenant = config.getValue("fixedTenant");
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public ClientCacheType getDefaultClientCacheType() {
        return this.defaultClientCacheType;
    }

    public long getMaxUploadFileSize() {
        return this.maxUploadFileSize;
    }

    public Pattern getExcluePathes() {
        return this.excludePathes;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public List<String> getRestPath() {
        return this.restPath;
    }

    public List<ContentDispositionPolicy> getContentDispositionPolicy() {
        return this.contentDispositionPolicies;
    }

    public String getDirectAccessPort() {
        return this.directAccessPort;
    }
}

