/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.definition.config.CommandConfig;
import org.iplass.mtp.command.interceptor.CommandInterceptor;
import org.iplass.mtp.impl.command.InterceptorService;
import org.iplass.mtp.impl.command.MetaCommand;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.web.ParameterValueMap;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.impl.web.WebRequestContext;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingRuntimeException;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.MetaTokenCheck;
import org.iplass.mtp.impl.web.actionmapping.NoBodyResponse;
import org.iplass.mtp.impl.web.actionmapping.ParamMap;
import org.iplass.mtp.impl.web.actionmapping.Result;
import org.iplass.mtp.impl.web.actionmapping.TemplateResult;
import org.iplass.mtp.impl.web.actionmapping.VariableParameterValueMap;
import org.iplass.mtp.impl.web.actionmapping.WebInvocationImpl;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaCacheCriteria;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.impl.web.template.TemplateService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.web.actionmapping.definition.ActionMappingDefinition;
import org.iplass.mtp.web.actionmapping.definition.ClientCacheType;
import org.iplass.mtp.web.actionmapping.definition.HttpMethodType;
import org.iplass.mtp.web.actionmapping.definition.ParamMapDefinition;
import org.iplass.mtp.web.actionmapping.definition.result.ResultDefinition;
import org.iplass.mtp.web.interceptor.RequestInterceptor;

public class MetaActionMapping
extends BaseRootMetaData
implements DefinableMetaData<ActionMappingDefinition> {
    private static final long serialVersionUID = -9160640479328183543L;
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String HEAD = "HEAD";
    private static final String OPTIONS = "OPTIONS";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private static final String TRACE = "TRACE";
    private ClientCacheType clientCacheType;
    private boolean isParts;
    private boolean isPrivilaged = false;
    private boolean isPublicAction;
    private MetaCommand command;
    private ParamMap[] paramMap;
    private Result[] result;
    private MetaTokenCheck tokenCheck;
    private MetaCacheCriteria cacheCriteria;
    private boolean synchronizeOnSession;
    private long clientCacheMaxAge = -1L;
    private HttpMethodType[] allowMethod;
    private boolean needTrustedAuthenticate;

    public boolean isNeedTrustedAuthenticate() {
        return this.needTrustedAuthenticate;
    }

    public void setNeedTrustedAuthenticate(boolean needTrustedAuthenticate) {
        this.needTrustedAuthenticate = needTrustedAuthenticate;
    }

    public HttpMethodType[] getAllowMethod() {
        return this.allowMethod;
    }

    public void setAllowMethod(HttpMethodType[] allowMethod) {
        this.allowMethod = allowMethod;
    }

    public long getClientCacheMaxAge() {
        return this.clientCacheMaxAge;
    }

    public void setClientCacheMaxAge(long clientCacheMaxAge) {
        this.clientCacheMaxAge = clientCacheMaxAge;
    }

    public boolean isSynchronizeOnSession() {
        return this.synchronizeOnSession;
    }

    public void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public MetaCacheCriteria getCacheCriteria() {
        return this.cacheCriteria;
    }

    public void setCacheCriteria(MetaCacheCriteria cacheCriteria) {
        this.cacheCriteria = cacheCriteria;
    }

    public boolean isPublicAction() {
        return this.isPublicAction;
    }

    public void setPublicAction(boolean isPublicAction) {
        this.isPublicAction = isPublicAction;
    }

    public boolean isPrivilaged() {
        return this.isPrivilaged;
    }

    public void setPrivilaged(boolean isPrivilaged) {
        this.isPrivilaged = isPrivilaged;
    }

    public ParamMap[] getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(ParamMap[] paramMap) {
        this.paramMap = paramMap;
    }

    public boolean isParts() {
        return this.isParts;
    }

    public void setParts(boolean isParts) {
        this.isParts = isParts;
    }

    public ClientCacheType getClientCacheType() {
        return this.clientCacheType;
    }

    public void setClientCacheType(ClientCacheType clientCacheType) {
        this.clientCacheType = clientCacheType;
    }

    public MetaCommand getCommand() {
        return this.command;
    }

    public void setCommand(MetaCommand command) {
        this.command = command;
    }

    public Result[] getResult() {
        return this.result;
    }

    public void setResult(Result[] result) {
        this.result = result;
    }

    public MetaTokenCheck getTokenCheck() {
        return this.tokenCheck;
    }

    public void setTokenCheck(MetaTokenCheck tokenCheck) {
        this.tokenCheck = tokenCheck;
    }

    public ActionMappingRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new ActionMappingRuntime(metaDataConfig);
    }

    public MetaActionMapping copy() {
        return (MetaActionMapping)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public void applyConfig(ActionMappingDefinition definition) {
        int i;
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.localizedDisplayNameList = I18nUtil.toMeta(definition.getLocalizedDisplayNameList());
        this.description = definition.getDescription();
        this.clientCacheType = definition.getClientCacheType();
        this.clientCacheMaxAge = definition.getClientCacheMaxAge();
        this.isParts = definition.isParts();
        this.isPrivilaged = definition.isPrivilaged();
        this.isPublicAction = definition.isPublicAction();
        if (definition.getCommandConfig() != null) {
            this.command = MetaCommand.createInstance((CommandConfig)definition.getCommandConfig());
            this.command.applyConfig(definition.getCommandConfig());
        } else {
            this.command = null;
        }
        if (definition.getParamMap() != null) {
            this.paramMap = new ParamMap[definition.getParamMap().length];
            i = 0;
            for (Serializable serializable : definition.getParamMap()) {
                this.paramMap[i] = new ParamMap();
                this.paramMap[i].applyConfig((ParamMapDefinition)serializable);
                ++i;
            }
        } else {
            this.paramMap = null;
        }
        if (definition.getResult() != null) {
            this.result = new Result[definition.getResult().length];
            i = 0;
            for (Serializable serializable : definition.getResult()) {
                this.result[i] = Result.createInstance((ResultDefinition)serializable);
                this.result[i].applyConfig((ResultDefinition)serializable);
                ++i;
            }
        } else {
            this.result = null;
        }
        if (definition.getTokenCheck() != null) {
            this.tokenCheck = new MetaTokenCheck();
            this.tokenCheck.applyConfig(definition.getTokenCheck());
        } else {
            this.tokenCheck = null;
        }
        if (definition.getCacheCriteria() != null) {
            this.cacheCriteria = MetaCacheCriteria.createInstance(definition.getCacheCriteria());
            this.cacheCriteria.applyConfig(definition.getCacheCriteria());
        } else {
            this.cacheCriteria = null;
        }
        this.synchronizeOnSession = definition.isSynchronizeOnSession();
        if (definition.getAllowMethod() != null) {
            this.allowMethod = new HttpMethodType[definition.getAllowMethod().length];
            System.arraycopy(definition.getAllowMethod(), 0, this.allowMethod, 0, this.allowMethod.length);
        } else {
            this.allowMethod = null;
        }
        this.needTrustedAuthenticate = definition.isNeedTrustedAuthenticate();
    }

    public ActionMappingDefinition currentConfig() {
        int i;
        ActionMappingDefinition definition = new ActionMappingDefinition();
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setLocalizedDisplayNameList(I18nUtil.toDef((List)this.localizedDisplayNameList));
        definition.setDescription(this.description);
        definition.setClientCacheType(this.clientCacheType);
        definition.setClientCacheMaxAge(this.clientCacheMaxAge);
        definition.setParts(this.isParts);
        definition.setPrivilaged(this.isPrivilaged);
        definition.setPublicAction(this.isPublicAction);
        if (this.command != null) {
            definition.setCommandConfig(this.command.currentConfig());
        }
        if (this.paramMap != null) {
            ParamMapDefinition[] paramMapDefinition = new ParamMapDefinition[this.paramMap.length];
            i = 0;
            for (ParamMap map : this.paramMap) {
                paramMapDefinition[i] = map.currentConfig();
                ++i;
            }
            definition.setParamMap(paramMapDefinition);
        }
        if (this.result != null) {
            ResultDefinition[] resultDefinition = new ResultDefinition[this.result.length];
            i = 0;
            for (Result res : this.result) {
                resultDefinition[i] = res.currentConfig();
                ++i;
            }
            definition.setResult(resultDefinition);
        }
        if (this.tokenCheck != null) {
            definition.setTokenCheck(this.tokenCheck.currentConfig());
        }
        if (this.cacheCriteria != null) {
            definition.setCacheCriteria(this.cacheCriteria.currentConfig());
        }
        definition.setSynchronizeOnSession(this.synchronizeOnSession);
        if (this.allowMethod != null) {
            definition.setAllowMethod(new HttpMethodType[this.allowMethod.length]);
            System.arraycopy(this.allowMethod, 0, definition.getAllowMethod(), 0, this.allowMethod.length);
        } else {
            definition.setAllowMethod(null);
        }
        definition.setNeedTrustedAuthenticate(this.needTrustedAuthenticate);
        return definition;
    }

    public class ActionMappingRuntime
    extends BaseMetaDataRuntime {
        private MetaCommand.CommandRuntime cmd;
        private Result.ResultRuntime defaultResult;
        private Result.ResultRuntime[] resultList;
        private Map<String, Result.ResultRuntime> exceptionResultMap;
        private HashMap<String, List<ParamMap.ParamMapRuntime>> paramMapRuntimes;
        private RequestInterceptor[] reqInterceptors;
        private CommandInterceptor[] cmdInterceptors;
        private ClientCacheType clientCacheTypeRuntime;
        private MetaCacheCriteria.CacheCriteriaRuntime cacheCriteriaRuntime;

        public ActionMappingRuntime(MetaDataConfig metaDataConfig) {
            try {
                TemplateService ts;
                MetaTemplate.TemplateRuntime tr;
                if (MetaActionMapping.this.command != null) {
                    this.cmd = MetaActionMapping.this.command.createRuntime();
                }
                if ((tr = (MetaTemplate.TemplateRuntime)(ts = (TemplateService)ServiceRegistry.getRegistry().getService(TemplateService.class)).getRuntimeByName(MetaActionMapping.this.name)) != null) {
                    this.defaultResult = new TemplateResult("*", tr.getMetaData().getId()).createRuntime();
                }
                if (MetaActionMapping.this.result != null) {
                    this.resultList = new Result.ResultRuntime[MetaActionMapping.this.result.length];
                    for (int i = 0; i < MetaActionMapping.this.result.length; ++i) {
                        this.resultList[i] = MetaActionMapping.this.result[i].createRuntime();
                        if ("*".equals(MetaActionMapping.this.result[i].getCommandResultStatus())) {
                            this.defaultResult = this.resultList[i];
                        }
                        if (MetaActionMapping.this.result[i].getExceptionClassName() == null) continue;
                        if (this.exceptionResultMap == null) {
                            this.exceptionResultMap = new HashMap<String, Result.ResultRuntime>();
                        }
                        this.exceptionResultMap.put(MetaActionMapping.this.result[i].getExceptionClassName(), this.resultList[i]);
                    }
                }
                if (MetaActionMapping.this.paramMap != null) {
                    this.paramMapRuntimes = new HashMap();
                    for (ParamMap p : MetaActionMapping.this.paramMap) {
                        ParamMap.ParamMapRuntime pmr = p.createRuntime();
                        List<ParamMap.ParamMapRuntime> pmrList = this.paramMapRuntimes.get(p.getName());
                        if (pmrList == null) {
                            pmrList = new LinkedList<ParamMap.ParamMapRuntime>();
                            this.paramMapRuntimes.put(p.getName(), pmrList);
                        }
                        pmrList.add(pmr);
                    }
                }
                WebFrontendService wfs = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
                this.clientCacheTypeRuntime = MetaActionMapping.this.getClientCacheType() == null ? wfs.getDefaultClientCacheType() : MetaActionMapping.this.getClientCacheType();
                if (MetaActionMapping.this.cacheCriteria != null) {
                    this.cacheCriteriaRuntime = MetaActionMapping.this.cacheCriteria.createRuntime(MetaActionMapping.this);
                }
                InterceptorService is = (InterceptorService)ServiceRegistry.getRegistry().getService(InterceptorService.class);
                this.cmdInterceptors = is.getInterceptors("web");
                ActionMappingService as = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
                this.reqInterceptors = as.getInterceptors();
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public MetaActionMapping getMetaData() {
            return MetaActionMapping.this;
        }

        public Result.ResultRuntime getResult(String cmdResult) {
            this.checkState();
            Result.ResultRuntime result = null;
            if (this.resultList == null) {
                result = this.defaultResult;
            } else {
                for (Result.ResultRuntime r : this.resultList) {
                    if (r.getMetaData().getCommandResultStatus() == null || !r.getMetaData().getCommandResultStatus().equals(cmdResult)) continue;
                    result = r;
                    break;
                }
                if (result == null && this.defaultResult != null) {
                    result = this.defaultResult;
                }
            }
            if (result == null) {
                throw new ActionMappingRuntimeException("no define result mapping:" + cmdResult + " of ActionMapping:" + this.getMetaData().getName());
            }
            return result;
        }

        public boolean isAllowedMethod(HttpMethodType requestMethod) {
            if (MetaActionMapping.this.allowMethod == null || MetaActionMapping.this.allowMethod.length == 0) {
                return true;
            }
            for (HttpMethodType m : MetaActionMapping.this.allowMethod) {
                if (m != requestMethod) continue;
                return true;
            }
            return false;
        }

        private void doOptions(WebRequestStack req) {
            String allow = this.allowString();
            req.getResponse().setHeader("Allow", allow);
        }

        private String allowString() {
            String allow;
            if (MetaActionMapping.this.allowMethod == null || MetaActionMapping.this.allowMethod.length == 0) {
                allow = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS";
            } else {
                StringBuilder sb = new StringBuilder();
                block6: for (HttpMethodType m : MetaActionMapping.this.allowMethod) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    switch (m) {
                        case GET: {
                            sb.append("GET, HEAD");
                            continue block6;
                        }
                        case POST: {
                            sb.append(MetaActionMapping.POST);
                            continue block6;
                        }
                        case PUT: {
                            sb.append(MetaActionMapping.PUT);
                            continue block6;
                        }
                        case DELETE: {
                            sb.append(MetaActionMapping.DELETE);
                            continue block6;
                        }
                    }
                }
                sb.append(", TRACE, OPTIONS");
                allow = sb.toString();
            }
            return allow;
        }

        private void doTrace(WebRequestStack req) throws IOException {
            String CRLF = "\r\n";
            StringBuilder buffer = new StringBuilder("TRACE ").append(req.getRequest().getRequestURI()).append(" ").append(req.getRequest().getProtocol());
            Enumeration reqHeaderEnum = req.getRequest().getHeaderNames();
            while (reqHeaderEnum.hasMoreElements()) {
                String headerName = (String)reqHeaderEnum.nextElement();
                buffer.append(CRLF).append(headerName).append(": ").append(req.getRequest().getHeader(headerName));
            }
            buffer.append(CRLF);
            int responseLength = buffer.length();
            req.getResponse().setContentType("message/http");
            req.getResponse().setContentLength(responseLength);
            ServletOutputStream out = req.getResponse().getOutputStream();
            out.print(buffer.toString());
            out.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeCommand(WebRequestStack req) throws IOException, ServletException {
            this.checkState();
            String httpMethod = req.getRequest().getMethod();
            HttpMethodType forCheck = null;
            switch (httpMethod) {
                case "TRACE": {
                    this.doTrace(req);
                    return;
                }
                case "OPTIONS": {
                    this.doOptions(req);
                    return;
                }
                case "DELETE": {
                    forCheck = HttpMethodType.DELETE;
                    break;
                }
                case "HEAD": {
                    req.setResponse((HttpServletResponse)new NoBodyResponse(req.getResponse()));
                    forCheck = HttpMethodType.GET;
                    break;
                }
                case "GET": {
                    forCheck = HttpMethodType.GET;
                    break;
                }
                case "POST": {
                    forCheck = HttpMethodType.POST;
                    break;
                }
                case "PUT": {
                    forCheck = HttpMethodType.PUT;
                    break;
                }
                default: {
                    req.getResponse().sendError(501);
                    return;
                }
            }
            if (!this.isAllowedMethod(forCheck)) {
                String protocol = req.getRequest().getProtocol();
                if (protocol.endsWith("1.1")) {
                    req.getResponse().setHeader("Allow", this.allowString());
                    req.getResponse().sendError(405);
                } else {
                    req.getResponse().sendError(400);
                }
                return;
            }
            if (MetaActionMapping.this.isParts && req.isClientDirectRequest()) {
                throw new WebProcessRuntimeException(MetaActionMapping.this.name + " is Parts.Can not direct call.");
            }
            switch (this.clientCacheTypeRuntime) {
                case CACHE: {
                    WebUtil.setCacheControlHeader(req, true, MetaActionMapping.this.clientCacheMaxAge);
                    break;
                }
                case NO_CACHE: {
                    WebUtil.setCacheControlHeader(req, false, -1L);
                    break;
                }
            }
            RequestContext requestContext = req.getRequestContext();
            requestContext.setAttribute("tenantContextPath", (Object)req.getRequestPath().getTenantContextPath(req.getRequest()));
            if (requestContext instanceof WebRequestContext) {
                WebRequestContext webRequestContext = (WebRequestContext)requestContext;
                ParameterValueMap currentValueMap = webRequestContext.getValueMap();
                if (MetaActionMapping.this.paramMap != null) {
                    VariableParameterValueMap variableValueMap = new VariableParameterValueMap(currentValueMap, req.getRequestPath(), this);
                    webRequestContext.setValueMap(variableValueMap);
                }
            }
            WebInvocationImpl invoke = new WebInvocationImpl(this.reqInterceptors, this.cmdInterceptors, this.cmd, requestContext, req, this);
            if (MetaActionMapping.this.isSynchronizeOnSession()) {
                SessionContext sessionContext = requestContext.getSession();
                synchronized (sessionContext) {
                    invoke.proceedRequest();
                }
            } else {
                invoke.proceedRequest();
            }
        }

        public Map<String, List<ParamMap.ParamMapRuntime>> getParamMapRuntimes() {
            this.checkState();
            return this.paramMapRuntimes;
        }

        public MetaCacheCriteria.CacheCriteriaRuntime getCacheCriteria() {
            return this.cacheCriteriaRuntime;
        }

        public Result.ResultRuntime getResult(Throwable t) {
            if (this.exceptionResultMap != null) {
                for (Class<?> tc = t.getClass(); tc != null && tc != Object.class; tc = tc.getSuperclass()) {
                    Result.ResultRuntime rr = this.exceptionResultMap.get(tc.getName());
                    if (rr == null) continue;
                    return rr;
                }
            }
            return null;
        }
    }
}

