/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.definition.annotation.LocalizedString;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.metadata.annotation.AnnotatableMetaDataFactory;
import org.iplass.mtp.impl.metadata.annotation.AnnotateMetaDataEntry;
import org.iplass.mtp.impl.web.template.MetaJspTemplate;
import org.iplass.mtp.util.StringUtil;

public class MetaTemplateFactory
implements AnnotatableMetaDataFactory<Template, Command> {
    public Class<Command> getAnnotatedClass() {
        return Command.class;
    }

    public Class<Template> getAnnotationClass() {
        return Template.class;
    }

    public Map<String, AnnotateMetaDataEntry> toMetaData(Class<Command> annotatedClass) {
        Template template = annotatedClass.getAnnotation(Template.class);
        return this.toMetaData(template, annotatedClass);
    }

    Map<String, AnnotateMetaDataEntry> toMetaData(Template template, Class<Command> annotatedClass) {
        HashMap<String, AnnotateMetaDataEntry> map = new HashMap<String, AnnotateMetaDataEntry>();
        MetaJspTemplate metaJspTemplate = new MetaJspTemplate();
        String path = "/template/" + template.name();
        metaJspTemplate.setName(template.name());
        if (!"##default".equals(template.id())) {
            metaJspTemplate.setId(template.id());
        } else {
            metaJspTemplate.setId(path);
        }
        if (!"##default".equals(template.displayName())) {
            metaJspTemplate.setDisplayName(template.displayName());
        }
        if (template.localizedDisplayName().length > 0) {
            ArrayList<MetaLocalizedString> localizedDisplayNameList = new ArrayList<MetaLocalizedString>();
            for (LocalizedString localeValue : template.localizedDisplayName()) {
                MetaLocalizedString metaLocaleValue = new MetaLocalizedString();
                metaLocaleValue.setLocaleName(localeValue.localeName());
                metaLocaleValue.setStringValue(localeValue.stringValue());
                localizedDisplayNameList.add(metaLocaleValue);
            }
            metaJspTemplate.setLocalizedDisplayNameList(localizedDisplayNameList);
        }
        if (!"##default".equals(template.description())) {
            metaJspTemplate.setDescription(template.description());
        }
        if (StringUtil.isNotEmpty((String)template.contentType())) {
            metaJspTemplate.setContentType(template.contentType());
        }
        if (StringUtil.isNotEmpty((String)template.path())) {
            metaJspTemplate.setPath(template.path());
        }
        if (StringUtil.isNotEmpty((String)template.layoutActionName())) {
            metaJspTemplate.setLayoutName(template.layoutActionName());
            metaJspTemplate.setLayoutResolveByName(true);
        }
        map.put(path, new AnnotateMetaDataEntry((RootMetaData)metaJspTemplate, template.overwritable(), false));
        return map;
    }
}

