/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.web.template.tags;

import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthTag
extends TagSupport
implements TryCatchFinally {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(AuthTag.class);
    private static Pattern sp = Pattern.compile("[,\\s]+");
    private Boolean privileged = Boolean.FALSE;
    private String role;
    private Permission permission;
    private AuthService authService = (AuthService)ServiceRegistry.getRegistry().getService(AuthService.class);
    private AuthContextHolder doAuthContext;
    private AuthContextHolder prev;

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public int doStartTag() throws JspException {
        AuthContext auth = AuthContext.getCurrentContext();
        if (this.role != null) {
            boolean userInRole = false;
            if (this.role.indexOf(44) < 0) {
                userInRole = auth.userInRole(this.role);
            } else {
                String[] roles;
                for (String r : roles = sp.split(this.role)) {
                    if (userInRole |= userInRole | auth.userInRole(r)) break;
                }
            }
            if (!userInRole) {
                if (log.isDebugEnabled()) {
                    log.debug("userInRole(\"" + this.role + "\") == false, SKIP_BODY");
                }
                return 0;
            }
        }
        if (this.permission != null && !auth.checkPermission(this.permission)) {
            if (log.isDebugEnabled()) {
                log.debug("checkPermission(" + this.permission + ") == false, SKIP_BODY");
            }
            return 0;
        }
        if (this.privileged != null && this.privileged.booleanValue()) {
            this.doAuthContext = AuthContextHolder.getAuthContext().privilegedAuthContextHolder();
            ExecuteContext exec = ExecuteContext.getCurrentContext();
            this.prev = this.authService.doSecuredActionPre(this.doAuthContext, exec);
        }
        return 1;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        if (this.privileged != null && this.privileged.booleanValue()) {
            ExecuteContext exec = ExecuteContext.getCurrentContext();
            this.authService.doSecuredActionPost(this.doAuthContext, true, this.prev, exec);
        }
        this.doAuthContext = null;
        this.prev = null;
        this.privileged = Boolean.FALSE;
        this.role = null;
        this.permission = null;
    }
}

