/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.web.template.tags;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.command.beanmapper.MappingError;
import org.iplass.mtp.command.beanmapper.MappingException;
import org.iplass.mtp.command.beanmapper.MappingResult;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.tags.BindTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorsTag
extends BodyTagSupport
implements TryCatchFinally {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ERROR_VARIABLE_NAME = "errors";
    public static final String DEFAULT_DELIMITER = "<br>";
    public static final String DEFAULT_HEADER = "<span class=\"error\">";
    public static final String DEFAULT_FOOTER = "</span>";
    private static Logger log = LoggerFactory.getLogger(ErrorsTag.class);
    private String errorsVariableName;
    private String delimiter;
    private String header;
    private String footer;
    private Object errors;
    private Boolean htmlEscape;
    private Object prevErrors;
    private BindTag parentTag;
    private boolean writeFirst;

    public String getErrorsVariableName() {
        return this.errorsVariableName;
    }

    public void setErrorsVariableName(String errorsVariableName) {
        this.errorsVariableName = errorsVariableName;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public Object getErrors() {
        return this.errors;
    }

    public void setErrors(Object errors) {
        this.errors = errors;
    }

    public boolean isHtmlEscape() {
        if (this.htmlEscape == null) {
            return false;
        }
        return this.htmlEscape;
    }

    public void setHtmlEscape(boolean htmlEscape) {
        this.htmlEscape = htmlEscape;
    }

    private void initParam() {
        this.parentTag = (BindTag)ErrorsTag.findAncestorWithClass((Tag)this, BindTag.class);
        if (this.errorsVariableName == null) {
            this.errorsVariableName = this.parentTag != null ? this.parentTag.getErrorsVariableName() : DEFAULT_ERROR_VARIABLE_NAME;
        }
        if (this.htmlEscape == null) {
            if (this.parentTag != null) {
                this.htmlEscape = this.parentTag.isHtmlEscape();
            }
            if (this.htmlEscape == null) {
                this.htmlEscape = Boolean.TRUE;
            }
        }
        if (this.delimiter == null) {
            this.delimiter = DEFAULT_DELIMITER;
        }
        if (this.header == null) {
            this.header = DEFAULT_HEADER;
        }
        if (this.footer == null) {
            this.footer = DEFAULT_FOOTER;
        }
    }

    public int doStartTag() throws JspException {
        this.initParam();
        if (this.errors == null) {
            MappingResult me;
            this.errors = this.pageContext.getAttribute(this.errorsVariableName);
            if (this.errors == null && this.parentTag != null && this.parentTag.isSetBean() && (me = this.parentTag.getMappingResult()) != null && me.hasError()) {
                this.errors = me.getErrors();
            }
            if (this.parentTag == null && this.errors == null) {
                this.errors = this.pageContext.getAttribute("mtp.web.exception", 2);
            }
        }
        if (this.errors == null) {
            return 0;
        }
        this.prevErrors = this.pageContext.getAttribute(this.errorsVariableName);
        this.pageContext.setAttribute(this.errorsVariableName, this.errors);
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.bodyContent == null) {
                if (this.errors != null) {
                    JspWriter out = this.pageContext.getOut();
                    out.print(this.header);
                    this.writeError(this.errors, out);
                    out.print(this.footer);
                }
            } else {
                this.bodyContent.writeOut((Writer)this.getPreviousOut());
            }
            this.pageContext.setAttribute(this.errorsVariableName, this.prevErrors);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    private void writeError(Object errors, JspWriter out) throws IOException {
        if (errors instanceof String) {
            this.writeMessage((String)errors, out);
        } else if (errors instanceof List) {
            for (Object e : (List)errors) {
                this.writeError(e, out);
            }
        } else if (errors instanceof Object[]) {
            Object[] array = (Object[])errors;
            for (int i = 0; i < array.length; ++i) {
                this.writeError(array[i], out);
            }
        } else if (errors instanceof MappingError) {
            for (String m : ((MappingError)errors).getErrorMessages()) {
                this.writeError(m, out);
            }
        } else if (errors instanceof MappingResult) {
            for (MappingError me : ((MappingResult)errors).getErrors()) {
                this.writeError(me, out);
            }
        } else if (errors instanceof MappingException) {
            this.writeError(((MappingException)errors).getResult(), out);
        } else if (errors instanceof ApplicationException) {
            this.writeMessage(((ApplicationException)((Object)errors)).getMessage(), out);
        } else if (errors instanceof Throwable) {
            if (log.isDebugEnabled()) {
                log.debug("System Exception: " + errors + " occoured. Message details are not output.");
            }
            if (this.writeFirst) {
                out.print(this.delimiter);
            } else {
                this.writeFirst = true;
            }
            this.writeMessage(ErrorsTag.resourceString("error.Error.retryMsg", new Object[0]), out);
        } else if (errors != null) {
            this.writeMessage(errors.toString(), out);
        }
    }

    private void writeMessage(String msg, JspWriter out) throws IOException {
        if (this.writeFirst) {
            out.print(this.delimiter);
        } else {
            this.writeFirst = true;
        }
        if (this.htmlEscape.booleanValue()) {
            out.print(StringUtil.escapeHtml((String)msg));
        } else {
            out.print(msg);
        }
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        this.bodyContent = null;
        this.errorsVariableName = null;
        this.delimiter = null;
        this.header = null;
        this.footer = null;
        this.errors = null;
        this.htmlEscape = null;
        this.parentTag = null;
        this.prevErrors = null;
        this.writeFirst = false;
    }

    private static String resourceString(String key, Object ... arguments) {
        return WebResourceBundleUtil.resourceString(key, arguments);
    }
}

