/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.auth.oidc;

import java.util.Map;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.oidc.definition.OpenIdConnectDefinition;

public interface AutoUserProvisioningHandler {
    default public void init(OpenIdConnectDefinition definition) {
    }

    public String createUser(String var1, String var2, Map<String, Object> var3);

    public void updateUser(User var1, String var2, String var3, Map<String, Object> var4);

    default public void attributeMappingToUserInstance(User user, String subjectId, String subjectName, Map<String, Object> attributes) {
        String accountId = (String)attributes.get("subjectIdWithOpenIdConnectDefinitionName");
        user.setAccountId(accountId);
        String gname = (String)attributes.get("given_name");
        String fname = (String)attributes.get("family_name");
        if (gname != null) {
            user.setFirstName(gname);
        }
        if (fname != null) {
            user.setLastName(fname);
        } else if (subjectName == null) {
            user.setLastName(accountId);
            user.setName(accountId);
        } else {
            user.setLastName(subjectName);
            user.setName(subjectName);
        }
        Object bv = attributes.get("email_verified");
        if (bv != null && bv instanceof Boolean && ((Boolean)bv).booleanValue()) {
            user.setMail((String)attributes.get("email"));
        }
    }

    default public User transientUser(String subjectId, String subjectName, Map<String, Object> attributes) {
        User u = new User();
        this.attributeMappingToUserInstance(u, subjectId, subjectName, attributes);
        u.setOid(u.getAccountId());
        return u;
    }
}

