/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc;

import java.io.Serializable;
import java.sql.Timestamp;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenHandler;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.Config;

public class ClientSecretHandler
extends AuthTokenHandler {
    public static final String TYPE_OIDC_CLIENT_SECRET = "OIDCCS";

    String getClientSecret(String metaDataId) {
        AuthToken at = this.authTokenStore().getBySeries(ExecuteContext.getCurrentContext().getClientTenantId(), this.getType(), metaDataId);
        if (at != null) {
            return at.getToken();
        }
        return null;
    }

    void saveClientSecret(String metaDataId, String clientSecret) {
        this.authTokenStore().deleteBySeries(ExecuteContext.getCurrentContext().getClientTenantId(), this.getType(), metaDataId);
        AuthToken at = this.newAuthToken(metaDataId, null, new ClientSecretInfo(this.getType(), metaDataId, clientSecret));
        this.authTokenStore().create(at);
    }

    void deleteClientSecret(String metaDataId) {
        this.authTokenStore().deleteBySeries(ExecuteContext.getCurrentContext().getClientTenantId(), this.getType(), metaDataId);
    }

    public void inited(AuthTokenService service, Config config) {
        super.inited(service, config);
        if (this.getType() == null) {
            this.setType(TYPE_OIDC_CLIENT_SECRET);
        }
        this.setVisible(false);
    }

    protected Serializable createDetails(String seriesString, String tokenString, String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        return null;
    }

    public AuthTokenInfo toAuthTokenInfo(AuthToken authToken) {
        return null;
    }

    public Credential toCredential(AuthToken newToken) {
        return new IdPasswordCredential(newToken.getSeries(), newToken.getToken());
    }

    public String newTokenString(AuthTokenInfo tokenInfo) {
        return ((ClientSecretInfo)tokenInfo).secret;
    }

    public String newSeriesString(String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        return ((ClientSecretInfo)tokenInfo).metaDataId;
    }

    private static class ClientSecretInfo
    implements AuthTokenInfo {
        private String type;
        private String metaDataId;
        private String secret;

        private ClientSecretInfo(String type, String metaDataId, String secret) {
            this.type = type;
            this.metaDataId = metaDataId;
            this.secret = secret;
        }

        public String getType() {
            return this.type;
        }

        public String getKey() {
            return this.metaDataId;
        }

        public String getDescription() {
            return null;
        }

        public Timestamp getStartDate() {
            return null;
        }
    }
}

