/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.oidc.AutoUserProvisioningHandler;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.hint.CacheHint;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.subquery.ScalarSubQuery;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.UserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.authenticate.oidc.MetaOpenIdConnect;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.oidc.OpenIdConnectService;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.builder.EntityBuilder;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.spi.ServiceRegistry;

public class OIDCUserEntityResolver
implements UserEntityResolver {
    private AuthService authService;
    private OpenIdConnectService oidcService;
    private List<String> eagerLoadReferenceProperty;
    private String filterCondition;
    private Condition filterConditionNode;

    public List<String> getEagerLoadReferenceProperty() {
        return this.eagerLoadReferenceProperty;
    }

    public void setEagerLoadReferenceProperty(List<String> eagerLoadReferenceProperty) {
        this.eagerLoadReferenceProperty = eagerLoadReferenceProperty;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public User searchUser(AccountHandle account) {
        OIDCAccountHandle ah = (OIDCAccountHandle)account;
        MetaOpenIdConnect.OpenIdConnectRuntime oidcr = (MetaOpenIdConnect.OpenIdConnectRuntime)this.oidcService.getRuntimeByName(ah.getOpenIdConnectDefinitionName());
        User user = this.searchUser(ah);
        if (user == null && oidcr.getMetaData().isEnableTransientUser()) {
            user = this.temporaryUser(ah, oidcr);
        }
        return user;
    }

    private User temporaryUser(OIDCAccountHandle ah, MetaOpenIdConnect.OpenIdConnectRuntime oidcr) {
        User user = oidcr.getAutoUserProvisioningHandler() != null ? oidcr.getAutoUserProvisioningHandler().transientUser(ah.getSubjectId(), ah.getSubjectName(), ah.getAttributeMap()) : new AutoUserProvisioningHandler(this){

            @Override
            public void updateUser(User user, String subjectId, String subjectName, Map<String, Object> attributes) {
            }

            @Override
            public String createUser(String subjectId, String subjectName, Map<String, Object> attributes) {
                return null;
            }
        }.transientUser(ah.getSubjectId(), ah.getSubjectName(), ah.getAttributeMap());
        if (user.getAccountPolicy() == null) {
            AuthenticationPolicyService authPolicyService = (AuthenticationPolicyService)ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);
            List list = authPolicyService.list();
            for (MetaDataEntryInfo mi : list) {
                MetaAuthenticationPolicy.AuthenticationPolicyRuntime apr = (MetaAuthenticationPolicy.AuthenticationPolicyRuntime)authPolicyService.getRuntimeById(mi.getId());
                if (!oidcr.isAllowedOnPolicy(apr)) continue;
                user.setAccountPolicy(apr.getMetaData().getName());
                break;
            }
        }
        return user;
    }

    private User searchUser(OIDCAccountHandle ah) {
        return (User)this.authService.doSecuredAction(AuthContextHolder.getAuthContext().privilegedAuthContextHolder(), () -> this.searchUserByOneEQL((String)ah.getAttributeMap().get("subjectIdWithOpenIdConnectDefinitionName")));
    }

    private User searchUserByOneEQL(String uniqueKeyOfOpenIdProviderAccount) {
        try {
            EntityContext ec = EntityContext.getCurrentContext();
            ArrayList<EntityField> selectVals = new ArrayList<EntityField>();
            EntityHandler userEh = ec.getHandlerByName("mtp.auth.User");
            for (PropertyHandler ph : userEh.getPropertyList(ec)) {
                if (!(ph instanceof PrimitivePropertyHandler)) continue;
                selectVals.add(new EntityField(ph.getName()));
            }
            if (this.eagerLoadReferenceProperty != null) {
                for (String refName : this.eagerLoadReferenceProperty) {
                    EntityHandler refEh = ((ReferencePropertyHandler)userEh.getPropertyCascade(refName, ec)).getReferenceEntityHandler(ec);
                    for (PropertyHandler ph : refEh.getPropertyList(ec)) {
                        if (!(ph instanceof PrimitivePropertyHandler)) continue;
                        selectVals.add(new EntityField(refName + "." + ph.getName()));
                    }
                }
            }
            Query q = new Query();
            q.setSelect(new Select(false, selectVals));
            q.select().addHint((Hint)new CacheHint(CacheHint.CacheScope.TRANSACTION));
            q.from("mtp.auth.User");
            Query subq = new Query().select(new Object[]{"userOid"}).from("mtp.auth.oidc.OpenIdProviderAccount").where((Condition)new Equals("uniqueKey", (Object)uniqueKeyOfOpenIdProviderAccount));
            Equals c = new Equals("oid", (Object)new ScalarSubQuery(subq));
            if (this.filterConditionNode != null) {
                c = new And(new Condition[]{c, (Condition)this.filterConditionNode.copy()});
            }
            q.where((Condition)c);
            String[] props = new String[q.getSelect().getSelectValues().size()];
            for (int i = 0; i < q.getSelect().getSelectValues().size(); ++i) {
                props[i] = ((ValueExpression)q.getSelect().getSelectValues().get(i)).toString();
            }
            final EntityBuilder eb = new EntityBuilder(userEh, ec, props);
            EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
            em.search(q, (Predicate)new Predicate<Object[]>(){

                @Override
                public boolean test(Object[] data) {
                    eb.handle(data, null);
                    return true;
                }
            });
            eb.finished();
            Collection result = eb.getCollection();
            if (!result.isEmpty()) {
                return (User)result.iterator().next();
            }
            return null;
        }
        catch (Exception e) {
            throw new EntityRuntimeException("failed to search mtp.auth.User.", (Throwable)e);
        }
    }

    public void inited(AuthService service, AuthenticationProvider provider) {
        this.authService = service;
        this.oidcService = (OpenIdConnectService)ServiceRegistry.getRegistry().getService(OpenIdConnectService.class);
        if (this.filterCondition != null) {
            this.filterConditionNode = Condition.newCondition((String)this.filterCondition);
        }
    }

    public String getUnmodifiableUniqueKeyProperty() {
        return "oid";
    }
}

