/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc.command;

import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.impl.auth.authenticate.oidc.MetaOpenIdConnect;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCCredential;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCRuntimeException;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCState;
import org.iplass.mtp.impl.auth.authenticate.oidc.OpenIdConnectService;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCallbackCommand
implements Command {
    public static final String PARAM_DEFINITION_NAME = "defName";
    public static final String STAT_SUCCESS = "SUCCESS";
    public static final String REQUEST_ERROR_TEMPLATE = "org.iplass.mtp.oidc.errorTemplate";
    private static Logger logger = LoggerFactory.getLogger(AbstractCallbackCommand.class);
    private OpenIdConnectService service = (OpenIdConnectService)ServiceRegistry.getRegistry().getService(OpenIdConnectService.class);
    private String sessionOidStateKey;

    public AbstractCallbackCommand(String sessionOidStateKey) {
        this.sessionOidStateKey = sessionOidStateKey;
    }

    public String execute(RequestContext request) {
        String error = StringUtil.stripToNull((String)request.getParam("error"));
        String defName = StringUtil.stripToNull((String)request.getParam(PARAM_DEFINITION_NAME));
        String stateToken = request.getParam("state");
        String code = request.getParam("code");
        String iss = request.getParam("iss");
        MetaOpenIdConnect.OpenIdConnectRuntime oidp = this.service.getOrDefault(defName);
        if (oidp == null) {
            throw new OIDCRuntimeException("no OpenIdProvider Definition:" + defName);
        }
        OIDCState state = null;
        SessionContext session = request.getSession(false);
        if (session != null && (state = (OIDCState)session.getAttribute(this.sessionOidStateKey)) != null) {
            session.removeAttribute(this.sessionOidStateKey);
        }
        this.setErrorTemplate(request, state);
        if (error != null) {
            String errorDesc = StringUtil.stripToEmpty((String)request.getParam("error_description"));
            String errorUri = StringUtil.stripToEmpty((String)request.getParam("error_uri"));
            logger.error("oidc error: error=" + error + ", error_desc=" + errorDesc + ", error_uri=" + errorUri);
            throw new ApplicationException(WebResourceBundleUtil.resourceString("impl.auth.authenticate.oidc.command.AbstractCallbackCommand.error", new Object[]{StringUtil.stripToEmpty((String)errorDesc), error}));
        }
        if (state == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("invalid state:" + String.valueOf(state));
            }
            logger.error("oidc error: error=invalid client state");
            throw new ApplicationException(WebResourceBundleUtil.resourceString("impl.auth.authenticate.oidc.command.AbstractCallbackCommand.error", new Object[]{"", "invalid_client_state"}));
        }
        OIDCCredential cre = new OIDCCredential(defName, code, stateToken, this.createRedirectUri(oidp, request), iss, state);
        this.executeImpl(oidp, request, cre);
        if (state.getBackUrlAfterAuth() == null) {
            throw new OIDCRuntimeException("No redirect url");
        }
        if (!WebUtil.isValidInternalUrl(state.getBackUrlAfterAuth())) {
            if (logger.isDebugEnabled()) {
                logger.debug("invalid redirect url: " + state.getBackUrlAfterAuth());
            }
            throw new OIDCRuntimeException("Invalid redirect url");
        }
        request.setAttribute("redirectPath", (Object)state.getBackUrlAfterAuth());
        return STAT_SUCCESS;
    }

    protected abstract void executeImpl(MetaOpenIdConnect.OpenIdConnectRuntime var1, RequestContext var2, OIDCCredential var3);

    protected abstract String createRedirectUri(MetaOpenIdConnect.OpenIdConnectRuntime var1, RequestContext var2);

    void setErrorTemplate(RequestContext request, OIDCState state) {
        String errorTmpl = null;
        if (state != null) {
            errorTmpl = state.getErrorTemplateName();
        }
        if (errorTmpl == null) {
            errorTmpl = "oidc/Error";
        }
        request.setAttribute(REQUEST_ERROR_TEMPLATE, (Object)errorTmpl);
    }
}

