/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc.command;

import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.action.TokenCheck;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.authenticate.oidc.MetaOpenIdConnect;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCRuntimeException;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCState;
import org.iplass.mtp.impl.auth.authenticate.oidc.OpenIdConnectService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMapping(name="oidc/connect", clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, tokenCheck=@TokenCheck(useFixedToken=true), paramMapping={@ParamMapping(name="defName", mapFrom="${paths}")}, result={@Result(status="SUCCESS", type=Result.Type.REDIRECT, allowExternalLocation=true, value="redirectPath")})
@CommandClass(name="mtp/oidc/AccountConnectCommand", displayName="OpenID Connect Account Connect processing")
public class AccountConnectCommand
implements Command {
    public static final String ACTION_NAME = "oidc/connect";
    public static final String PARAM_DEFINITION_NAME = "defName";
    public static final String STAT_SUCCESS = "SUCCESS";
    public static final String SESSION_OIDC_STATE = "org.iplass.mtp.oidc.connect.state";
    private static Logger logger = LoggerFactory.getLogger(AccountConnectCommand.class);
    private OpenIdConnectService service = (OpenIdConnectService)ServiceRegistry.getRegistry().getService(OpenIdConnectService.class);
    private AuthenticationPolicyService policyService = (AuthenticationPolicyService)ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);

    public String execute(RequestContext request) {
        String defName = StringUtil.stripToNull((String)request.getParam(PARAM_DEFINITION_NAME));
        MetaOpenIdConnect.OpenIdConnectRuntime oidp = this.service.getOrDefault(defName);
        if (oidp == null) {
            throw new OIDCRuntimeException("no OpenIdProvider Definition:" + defName);
        }
        User user = AuthContext.getCurrentContext().getUser();
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime userPolicy = this.policyService.getOrDefault(user.getAccountPolicy());
        if (!oidp.isAllowedOnPolicy(userPolicy)) {
            throw new OIDCRuntimeException("policy not allow OpenIdConnectDefinition:" + oidp.getMetaData().getName());
        }
        String backUrlAfterConnect = oidp.backUrlAfterConnect(request);
        if (backUrlAfterConnect == null) {
            backUrlAfterConnect = (String)request.getAttribute("redirectPath");
        }
        String errorTemplate = (String)request.getAttribute("org.iplass.mtp.oidc.errorTemplate");
        OIDCState state = oidp.newOIDCState(backUrlAfterConnect, oidp.createRedirectUri(request, "oidc/connectcb"), errorTemplate);
        request.getSession().setAttribute(SESSION_OIDC_STATE, (Object)state);
        String redirect = oidp.authorizeUrl(state);
        if (logger.isDebugEnabled()) {
            logger.debug("redirect to OP:" + redirect);
        }
        request.setAttribute("redirectPath", (Object)redirect);
        return STAT_SUCCESS;
    }
}

