/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc.command;

import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApiParamMapping;
import org.iplass.mtp.command.annotation.webapi.WebApiTokenCheck;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.authenticate.oidc.MetaOpenIdConnect;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCRuntimeException;
import org.iplass.mtp.impl.auth.authenticate.oidc.OpenIdConnectService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.webapi.definition.CacheControlType;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="oidc/disconnect", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, cacheControlType=CacheControlType.NO_CACHE, tokenCheck=@WebApiTokenCheck(useFixedToken=true), paramMapping={@WebApiParamMapping(name="defName", mapFrom="${paths}")})
@CommandClass(name="mtp/oidc/AccountDisconnectCommand", displayName="OpenID Connect Account Disconnect processing")
public class AccountDisconnectCommand
implements Command {
    static final String WEBAPI_NAME = "oidc/disconnect";
    static final String PARAM_DEFINITION_NAME = "defName";
    static final String STAT_SUCCESS = "SUCCESS";
    private OpenIdConnectService service = (OpenIdConnectService)ServiceRegistry.getRegistry().getService(OpenIdConnectService.class);
    private AuthenticationPolicyService policyService = (AuthenticationPolicyService)ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);

    public String execute(RequestContext request) {
        String defName = StringUtil.stripToNull((String)request.getParam(PARAM_DEFINITION_NAME));
        MetaOpenIdConnect.OpenIdConnectRuntime oidp = this.service.getOrDefault(defName);
        if (oidp == null) {
            throw new OIDCRuntimeException("no OpenIdProvider Definition:" + defName);
        }
        User user = AuthContext.getCurrentContext().getUser();
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime userPolicy = this.policyService.getOrDefault(user.getAccountPolicy());
        if (!oidp.isAllowedOnPolicy(userPolicy)) {
            throw new OIDCRuntimeException("policy not allow OpenIdConnectDefinition:" + oidp.getMetaData().getName());
        }
        oidp.disconnect(user.getOid());
        return STAT_SUCCESS;
    }
}

