/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.token.web;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenClientStore;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.web.template.TemplateUtil;

public class AuthTokenCookieStore
implements AuthTokenClientStore {
    private String cookieName;

    public AuthTokenCookieStore() {
    }

    public AuthTokenCookieStore(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setToken(String token, int maxAgeSeconds) {
        WebRequestStack reqStack;
        if (token != null && (reqStack = WebRequestStack.getCurrent()) != null) {
            Cookie cookie = new Cookie(this.getCookieName(), token);
            cookie.setHttpOnly(true);
            cookie.setMaxAge(maxAgeSeconds);
            cookie.setPath(TemplateUtil.getTenantContextPath() + "/");
            cookie.setSecure(reqStack.getRequest().isSecure());
            reqStack.getResponse().addCookie(cookie);
        }
    }

    public String getToken() {
        return this.getToken(WebRequestStack.getCurrent());
    }

    private String getToken(WebRequestStack reqStack) {
        Cookie[] cookies;
        HttpServletRequest req;
        if (reqStack != null && (req = reqStack.getRequest()) != null && (cookies = req.getCookies()) != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(this.getCookieName())) continue;
                return c.getValue();
            }
        }
        return null;
    }

    public void clearToken() {
        WebRequestStack reqStack = WebRequestStack.getCurrent();
        if (reqStack != null && this.getToken(reqStack) != null) {
            Cookie cookie = new Cookie(this.getCookieName(), null);
            cookie.setHttpOnly(true);
            cookie.setMaxAge(0);
            cookie.setPath(TemplateUtil.getTenantContextPath() + "/");
            reqStack.getResponse().addCookie(cookie);
        }
    }
}

