/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.action;

import java.util.LinkedList;
import java.util.List;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.action.ActionPermissionEntry;
import org.iplass.mtp.impl.auth.authorize.builtin.role.RoleContext;
import org.iplass.mtp.impl.web.auth.ActionAuthContext;
import org.iplass.mtp.web.actionmapping.permission.ActionPermission;

class BuiltinActionAuthContext
extends BuiltinAuthorizationContext
implements ActionAuthContext {
    private final ActionPermissionEntry[] permissionEntry;
    private final TenantAuthorizeContext tenantAuthContext;
    private boolean hasParameterCondition;

    BuiltinActionAuthContext(String actionPath, ActionPermissionEntry[] permissionEntry, TenantAuthorizeContext tenantAuthContext) {
        super(actionPath);
        this.permissionEntry = permissionEntry;
        this.tenantAuthContext = tenantAuthContext;
        if (permissionEntry != null) {
            for (ActionPermissionEntry ape : permissionEntry) {
                if (!ape.hasParam()) continue;
                this.hasParameterCondition = true;
                break;
            }
        }
    }

    private List<ActionPermissionEntry> listTarget(AuthContextHolder userAuthContext) {
        LinkedList<ActionPermissionEntry> target = new LinkedList<ActionPermissionEntry>();
        long currentPriority = 0L;
        for (int i = 0; i < this.permissionEntry.length; ++i) {
            if (!userAuthContext.userInRole(this.permissionEntry[i].getRole(), this.tenantAuthContext.getTenantContext().getTenantId())) continue;
            RoleContext role = this.tenantAuthContext.getRoleContext(this.permissionEntry[i].getRole());
            if (currentPriority < role.getPriority()) {
                currentPriority = role.getPriority();
                target.clear();
            }
            if (currentPriority != role.getPriority()) continue;
            target.add(this.permissionEntry[i]);
        }
        return target;
    }

    public boolean isPermit(Permission permission, AuthContextHolder user) {
        UserBinding userBinding = user.newUserBinding(this.tenantAuthContext);
        if (userBinding.isGrantAllPermissions()) {
            return true;
        }
        ActionPermission ap = (ActionPermission)permission;
        List<ActionPermissionEntry> target = this.listTarget(user);
        for (ActionPermissionEntry pe : target) {
            if (!pe.isPermit(user, ap.getActionName(), ap.getParameter(), this.tenantAuthContext)) continue;
            return true;
        }
        return false;
    }

    public boolean isResultCacheable(Permission permission) {
        return !this.hasParameterCondition;
    }
}

