/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.webapi;

import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.webapi.WebApiParameterBinding;
import org.iplass.mtp.impl.command.RequestContextBinding;
import org.iplass.mtp.impl.command.SessionBinding;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.webapi.permission.WebApiParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebApiPermissionEntry {
    private static final Logger logger = LoggerFactory.getLogger(WebApiPermissionEntry.class);
    private static final String SCRIPT_PREFIX = "WebApiPermissionEntry_parameterCond";
    private String role;
    private Script parameterCondition;
    private boolean isScriptError = false;

    WebApiPermissionEntry(String role, String oid, String parameterConditionExp) {
        this.role = role;
        if (parameterConditionExp != null) {
            ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            try {
                this.parameterCondition = se.createScript(parameterConditionExp, "WebApiPermissionEntry_parameterCond_" + oid);
            }
            catch (RuntimeException e) {
                logger.error("parameter condition expression is invalid, so set permission to Not Allowed: " + parameterConditionExp, (Throwable)e);
                this.isScriptError = true;
            }
        }
    }

    public boolean hasParam() {
        return this.parameterCondition != null;
    }

    public String getRole() {
        return this.role;
    }

    public boolean isPermit(AuthContextHolder userContext, String webApiName, WebApiParameter param, TenantAuthorizeContext authContext) {
        Boolean ret;
        if (this.isScriptError) {
            return false;
        }
        if (this.parameterCondition == null) {
            return true;
        }
        ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
        ScriptContext sc = se.newScriptContext();
        sc.setAttribute("user", (Object)userContext.newUserBinding(authContext));
        sc.setAttribute("session", (Object)SessionBinding.newSessionBinding());
        sc.setAttribute("webApi", (Object)webApiName);
        sc.setAttribute("parameter", (Object)new WebApiParameterBinding(param));
        sc.setAttribute("request", (Object)RequestContextBinding.newRequestContextBinding());
        try {
            ret = (Boolean)this.parameterCondition.eval(sc);
        }
        catch (RuntimeException e) {
            logger.error("can not eval condition expression. so return not Allowed:" + e.getMessage(), (Throwable)e);
            return false;
        }
        return ret != null && ret != false;
    }
}

