/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.idtoken;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationCode;
import org.iplass.mtp.impl.auth.oauth.jwt.CertificateKeyPair;
import org.iplass.mtp.impl.auth.oauth.jwt.JwtProcessor;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.auth.oauth.util.OAuthUtil;

public class IdToken {
    private Map<String, Object> userInfoClaims;
    private String aud;
    private long exp;
    private long iat;
    private long authTime;
    private String nonce;
    private String at;
    private String c;
    private OAuthAuthorizationService service;

    public IdToken(AuthorizationCode code, AccessToken accessToken, MetaOAuthAuthorization.OAuthAuthorizationRuntime server, MetaOAuthClient.OAuthClientRuntime client, OAuthAuthorizationService service) {
        this.service = service;
        this.userInfoClaims = server.userInfo(accessToken, client);
        this.aud = client.getMetaData().getName();
        this.iat = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        this.exp = this.iat + service.getIdTokenLifetimeSeconds();
        this.authTime = code.getRequest().getAuthTime();
        this.nonce = code.getRequest().getNonce();
        this.at = accessToken.getTokenEncoded();
        this.c = code.getCodeValue();
    }

    public String getTokenEncoded(String issuerId) {
        JwtProcessor processor = this.service.getJwtProcessor();
        if (this.service.getJwtKeyStore() == null) {
            throw new NullPointerException("jwtKeyStore not defined on OAuthAuthorizationService.");
        }
        CertificateKeyPair key = this.service.getJwtKeyStore().getCertificateKeyPair();
        HashMap<String, Object> claims = new HashMap<String, Object>(this.userInfoClaims);
        claims.put("iss", issuerId);
        claims.put("aud", this.aud);
        claims.put("exp", this.exp);
        claims.put("iat", this.iat);
        claims.put("auth_time", this.authTime);
        if (this.nonce != null) {
            claims.put("nonce", this.nonce);
        }
        String jwtSignAlg = processor.preferredAlgorithm(key);
        if (this.at != null) {
            claims.put("at_hash", OAuthUtil.atHash(this.at, jwtSignAlg));
        }
        if (this.c != null) {
            claims.put("c_hash", OAuthUtil.cHash(this.c, jwtSignAlg));
        }
        return processor.encode(claims, key);
    }

    public Map<String, Object> getUserInfoClaims() {
        return this.userInfoClaims;
    }

    public String getAud() {
        return this.aud;
    }

    public long getExp() {
        return this.exp;
    }

    public long getIat() {
        return this.iat;
    }

    public long getAuthTime() {
        return this.authTime;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getAt() {
        return this.at;
    }

    public String getC() {
        return this.c;
    }
}

