/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import io.jsonwebtoken.security.SignatureException;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.iplass.mtp.impl.auth.oauth.jwt.CertificateKeyPair;
import org.iplass.mtp.impl.auth.oauth.jwt.InvalidJwtException;
import org.iplass.mtp.impl.auth.oauth.jwt.InvalidKeyException;
import org.iplass.mtp.impl.auth.oauth.jwt.Jwt;
import org.iplass.mtp.impl.auth.oauth.jwt.JwtProcessor;

public class JjwtProcesor
implements JwtProcessor {
    private boolean useRsaSsaPss;

    public boolean isUseRsaSsaPss() {
        return this.useRsaSsaPss;
    }

    public void setUseRsaSsaPss(boolean useRsaSsaPss) {
        this.useRsaSsaPss = useRsaSsaPss;
    }

    @Override
    public String encode(Map<String, Object> claims, CertificateKeyPair key) throws InvalidKeyException {
        try {
            return Jwts.builder().addClaims(claims).setHeaderParam("kid", (Object)key.getKeyId()).signWith((Key)key.getPrivateKey(), this.forSigningKey(key.getPrivateKey())).compact();
        }
        catch (io.jsonwebtoken.security.InvalidKeyException e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
    }

    private SignatureAlgorithm forSigningKey(PrivateKey key) {
        SignatureAlgorithm alg = SignatureAlgorithm.forSigningKey((Key)key);
        if (this.useRsaSsaPss) {
            if (alg == SignatureAlgorithm.RS256) {
                alg = SignatureAlgorithm.PS256;
            } else if (alg == SignatureAlgorithm.RS384) {
                alg = SignatureAlgorithm.PS384;
            } else if (alg == SignatureAlgorithm.RS512) {
                alg = SignatureAlgorithm.PS512;
            }
        }
        return alg;
    }

    @Override
    public String preferredAlgorithm(CertificateKeyPair key) throws InvalidKeyException {
        try {
            SignatureAlgorithm alg = this.forSigningKey(key.getPrivateKey());
            return alg.getValue();
        }
        catch (io.jsonwebtoken.security.InvalidKeyException e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
    }

    @Override
    public void checkValidVerificationKey(String algName, CertificateKeyPair key) throws InvalidKeyException {
        try {
            SignatureAlgorithm alg = SignatureAlgorithm.forName((String)algName);
            alg.assertValidVerificationKey((Key)key.getPublicKey());
        }
        catch (io.jsonwebtoken.security.InvalidKeyException | SignatureException e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
    }

    @Override
    public Jwt decode(String jwt, int allowedClockSkewMinutes, final Function<String, Map<String, Object>> jwkResolver) throws InvalidKeyException, InvalidJwtException {
        try {
            Jws claims = Jwts.parserBuilder().setSigningKeyResolver((SigningKeyResolver)new SigningKeyResolverAdapter(){

                public Key resolveSigningKey(JwsHeader jwsHeader, Claims claims) {
                    String keyId = jwsHeader.getKeyId();
                    Map jwk = (Map)jwkResolver.apply(keyId);
                    if (jwk == null) {
                        throw new InvalidJwtException("JWK is not defined for specific keyId:" + keyId);
                    }
                    String use = (String)jwk.get("use");
                    if (use != null && !use.equals("sig")) {
                        throw new InvalidKeyException("invalid use parameter:" + use);
                    }
                    String alg = (String)jwk.get("alg");
                    if (alg != null) {
                        String algFromHeader = jwsHeader.getAlgorithm();
                        if (algFromHeader != null && !alg.equalsIgnoreCase(algFromHeader)) {
                            throw new InvalidJwtException("alg parameter unmatch:" + algFromHeader);
                        }
                    } else {
                        alg = jwsHeader.getAlgorithm();
                    }
                    if (alg == null || alg.equalsIgnoreCase("none")) {
                        throw new InvalidJwtException("alg parameter unspecified or none specified:" + alg);
                    }
                    CertificateKeyPair key = new CertificateKeyPair(jwk);
                    JjwtProcesor.this.checkValidVerificationKey(alg, key);
                    return key.getPublicKey();
                }
            }).setAllowedClockSkewSeconds(TimeUnit.MINUTES.toSeconds(allowedClockSkewMinutes)).build().parseClaimsJws(jwt);
            return new Jwt((Map<String, Object>)claims.getHeader(), (Map)claims.getBody());
        }
        catch (io.jsonwebtoken.security.InvalidKeyException e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
        catch (JwtException e) {
            throw new InvalidJwtException(e.getMessage(), e);
        }
    }
}

