/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.subtypes;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.oauth.definition.SubjectIdentifierTypeDefinition;
import org.iplass.mtp.auth.oauth.definition.subtypes.PublicSubjectIdentifierTypeDefinition;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.MetaSubjectIdentifierType;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;

public class MetaPublicSubjectIdentifierType
extends MetaSubjectIdentifierType {
    private static final long serialVersionUID = 7872789897631127807L;
    private String subjectIdMappedUserProperty;
    private boolean hashing;

    public boolean isHashing() {
        return this.hashing;
    }

    public void setHashing(boolean hashing) {
        this.hashing = hashing;
    }

    public String getSubjectIdMappedUserProperty() {
        return this.subjectIdMappedUserProperty;
    }

    public void setSubjectIdMappedUserProperty(String subjectIdMappedUserProperty) {
        this.subjectIdMappedUserProperty = subjectIdMappedUserProperty;
    }

    @Override
    public PublicSubjectIdentifierTypeRuntime createRuntime() {
        return new PublicSubjectIdentifierTypeRuntime();
    }

    @Override
    public void applyConfig(SubjectIdentifierTypeDefinition subjectIdentifierType) {
        PublicSubjectIdentifierTypeDefinition def = (PublicSubjectIdentifierTypeDefinition)subjectIdentifierType;
        this.subjectIdMappedUserProperty = def.getSubjectIdMappedUserProperty();
        this.hashing = def.isHashing();
    }

    @Override
    public SubjectIdentifierTypeDefinition currentConfig() {
        PublicSubjectIdentifierTypeDefinition def = new PublicSubjectIdentifierTypeDefinition();
        def.setSubjectIdMappedUserProperty(this.subjectIdMappedUserProperty);
        def.setHashing(this.hashing);
        return def;
    }

    public class PublicSubjectIdentifierTypeRuntime
    extends MetaSubjectIdentifierType.SubjectIdentifierTypeRuntime {
        private OAuthAuthorizationService oauthAuthService = (OAuthAuthorizationService)ServiceRegistry.getRegistry().getService(OAuthAuthorizationService.class);

        public PublicSubjectIdentifierTypeRuntime() {
            if (MetaPublicSubjectIdentifierType.this.hashing && (this.oauthAuthService.getSubjectIdHashAlgorithm() == null || this.oauthAuthService.getSubjectIdHashSalt() == null)) {
                throw new IllegalStateException("no hashing configration defined. OAuthAuthorizationService's subjectIdHashAlgorithm and subjectIdHashSalt must specify.");
            }
        }

        @Override
        public String subjectId(User user, MetaOAuthClient.OAuthClientRuntime client) {
            Object value = user.getValue(MetaPublicSubjectIdentifierType.this.subjectIdMappedUserProperty);
            if (value == null) {
                return null;
            }
            String ret = value.toString();
            if (MetaPublicSubjectIdentifierType.this.hashing) {
                try {
                    MessageDigest md = MessageDigest.getInstance(this.oauthAuthService.getSubjectIdHashAlgorithm());
                    String msg = ret + "-" + ExecuteContext.getCurrentContext().getClientTenantId() + "-" + this.oauthAuthService.getSubjectIdHashSalt();
                    byte[] bytes = md.digest(msg.getBytes("UTF-8"));
                    ret = Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
                }
                catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
            return ret;
        }

        @Override
        public User handleOnLoad(User user) {
            Object value = user.getValue(MetaPublicSubjectIdentifierType.this.subjectIdMappedUserProperty);
            if (value == null) {
                EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
                User u = (User)em.load(user.getOid(), "mtp.auth.User", new LoadOption(false, false));
                value = u.getValue(MetaPublicSubjectIdentifierType.this.subjectIdMappedUserProperty);
                if (value == null) {
                    value = "s" + StringUtil.randomToken();
                    u.setValue(MetaPublicSubjectIdentifierType.this.subjectIdMappedUserProperty, value);
                    em.update((Entity)u, new UpdateOption(true).add(MetaPublicSubjectIdentifierType.this.subjectIdMappedUserProperty));
                }
                user.setValue(MetaPublicSubjectIdentifierType.this.subjectIdMappedUserProperty, value);
            }
            return user;
        }
    }
}

