/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.token.opaque;

import java.util.ArrayList;
import java.util.HashSet;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.oauth.AccessTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.token.opaque.AccessTokenHandler;
import org.iplass.mtp.impl.auth.oauth.token.opaque.AccessTokenMement;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OpaqueRefreshToken;
import org.iplass.mtp.impl.auth.oauth.token.opaque.TokenCreationStrategy;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.transaction.Transaction;

public class NewTokenCreationStrategy
implements TokenCreationStrategy {
    @Override
    public AuthToken create(MetaOAuthClient.OAuthClientRuntime client, AccessTokenHandler handler, String userUniqueId, AccessTokenInfo accessTokenInfo) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        String series = handler.newSeriesString(userUniqueId, null, accessTokenInfo);
        AuthToken at = (AuthToken)Transaction.requiresNew(t -> {
            AuthToken storeToken = handler.authTokenStore().getBySeries(tenantId, handler.getType(), series);
            AccessTokenInfo mergedAccessTokenInfo = accessTokenInfo;
            if (storeToken != null) {
                AccessTokenMement atm = (AccessTokenMement)storeToken.getDetails();
                if (!atm.getResouceOwnerId().equals(userUniqueId) || !client.getMetaData().getId().equals(atm.getClientMetaDataId())) {
                    throw new SystemException("AccessToken's series hash may have collision: client=" + atm.getClientMetaDataId() + " ,series=" + series);
                }
                HashSet<String> mergedScopes = new HashSet<String>();
                if (atm.getGrantedScopes() != null) {
                    mergedScopes.addAll(atm.getGrantedScopes());
                }
                mergedScopes.addAll(accessTokenInfo.getGrantedScopes());
                mergedAccessTokenInfo = new AccessTokenInfo();
                mergedAccessTokenInfo.setClientName(accessTokenInfo.getClientName());
                mergedAccessTokenInfo.setGrantedScopes(new ArrayList<String>(mergedScopes));
                handler.authTokenStore().deleteBySeries(tenantId, handler.getType(), series);
            }
            AuthToken newToken = handler.newAuthToken(userUniqueId, null, mergedAccessTokenInfo);
            handler.authTokenStore().create(newToken);
            return newToken;
        });
        return at;
    }

    @Override
    public AuthToken create(MetaOAuthClient.OAuthClientRuntime client, AccessTokenHandler handler, OpaqueRefreshToken refreshToken) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        String series = refreshToken.getSeries();
        AuthToken at = (AuthToken)Transaction.requiresNew(t -> {
            AuthToken storeToken = handler.authTokenStore().getBySeries(tenantId, handler.getType(), series);
            if (storeToken == null) {
                return null;
            }
            AccessTokenMement atm = (AccessTokenMement)storeToken.getDetails();
            if (!client.getMetaData().getId().equals(atm.getClientMetaDataId())) {
                throw new SystemException("AccessToken's series hash may have collision: client=" + atm.getClientMetaDataId() + " ,series=" + series);
            }
            AccessTokenInfo newAccessTokenInfo = new AccessTokenInfo();
            newAccessTokenInfo.setClientName(client.getMetaData().getName());
            newAccessTokenInfo.setGrantedScopes(new ArrayList<String>(atm.getGrantedScopes()));
            AuthToken newToken = handler.newAuthToken(storeToken.getOwnerId(), null, newAccessTokenInfo);
            handler.authTokenStore().update(newToken, storeToken);
            return newToken;
        });
        return at;
    }
}

