/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.token.opaque;

import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.token.RefreshToken;
import org.iplass.mtp.impl.auth.oauth.token.opaque.RefreshTokenMement;

public class OpaqueRefreshToken
extends RefreshToken {
    private String series;
    private String tokenEncoded;
    private long expires;
    private long expiresIn;
    private String clientId;

    public OpaqueRefreshToken(MetaOAuthClient.OAuthClientRuntime client, RefreshTokenMement mement, String series, String tokenEncoded) {
        this.series = series;
        this.tokenEncoded = tokenEncoded;
        this.expires = mement.getExpires();
        this.expiresIn = (this.expires - System.currentTimeMillis()) / 1000L;
        this.clientId = client.getMetaData().getName();
    }

    public String getSeries() {
        return this.series;
    }

    @Override
    public String getTokenEncoded() {
        return this.tokenEncoded;
    }

    @Override
    public long getExpiresIn() {
        return this.expiresIn;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }
}

