/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.token.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.builtin.web.BasicAuthUtil;
import org.iplass.mtp.impl.auth.oauth.AccessTokenAccountHandle;
import org.iplass.mtp.impl.auth.oauth.ClientAuthenticationMethod;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.OAuthRuntimeException;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.auth.oauth.token.OAuthAccessTokenStore;
import org.iplass.mtp.impl.auth.oauth.token.RefreshToken;
import org.iplass.mtp.impl.auth.oauth.token.remote.IntroResponse;
import org.iplass.mtp.impl.auth.oauth.token.remote.RemoteAccessToken;
import org.iplass.mtp.impl.auth.oauth.token.remote.TenantValidationType;
import org.iplass.mtp.impl.auth.oauth.token.remote.UserEntityResolverHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.http.ExponentialBackoff;
import org.iplass.mtp.impl.http.HttpClientConfig;
import org.iplass.mtp.impl.http.SimpleHttpInvoker;
import org.iplass.mtp.impl.webapi.jackson.WebApiObjectMapperService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteOAuthAccessTokenStore
implements OAuthAccessTokenStore,
ServiceInitListener<OAuthAuthorizationService> {
    private static Logger logger = LoggerFactory.getLogger(RemoteOAuthAccessTokenStore.class);
    private static final String TENANT_NAME_VARIABLE = "${tenantName}";
    private TenantValidationType tenantValidationType = TenantValidationType.NAME;
    private String introspectionEndpointUrl;
    private ClientAuthenticationMethod authenticationMethod = ClientAuthenticationMethod.CLIENT_SECRET_BASIC;
    private String resourceServerId;
    private String resourceServerSecret;
    private HttpClientConfig httpClientConfig;
    private ExponentialBackoff exponentialBackoff;
    private boolean reloadUser;
    private WebApiObjectMapperService objectMapperService;
    private SimpleHttpInvoker httpInvoker;

    public ClientAuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(ClientAuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    public ExponentialBackoff getExponentialBackoff() {
        return this.exponentialBackoff;
    }

    public void setExponentialBackoff(ExponentialBackoff exponentialBackoff) {
        this.exponentialBackoff = exponentialBackoff;
    }

    public TenantValidationType getTenantValidationType() {
        return this.tenantValidationType;
    }

    public void setTenantValidationType(TenantValidationType tenantValidationType) {
        this.tenantValidationType = tenantValidationType;
    }

    public String getIntrospectionEndpointUrl() {
        return this.introspectionEndpointUrl;
    }

    public void setIntrospectionEndpointUrl(String introspectionEndpointUrl) {
        this.introspectionEndpointUrl = introspectionEndpointUrl;
    }

    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public void setResourceServerId(String resourceServerId) {
        this.resourceServerId = resourceServerId;
    }

    public String getResourceServerSecret() {
        return this.resourceServerSecret;
    }

    public void setResourceServerSecret(String resourceServerSecret) {
        this.resourceServerSecret = resourceServerSecret;
    }

    public boolean isReloadUser() {
        return this.reloadUser;
    }

    public void setReloadUser(boolean reloadUser) {
        this.reloadUser = reloadUser;
    }

    @Override
    public AccessToken getAccessToken(String tokenString) {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        String endpoint = this.introspectionEndpointUrl.replace(TENANT_NAME_VARIABLE, ec.getCurrentTenant().getName());
        HttpPost post = new HttpPost(endpoint);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        post.setHeader("Accept", (Object)"application/json");
        if (this.authenticationMethod == ClientAuthenticationMethod.CLIENT_SECRET_BASIC) {
            IdPasswordCredential idPass = new IdPasswordCredential(this.resourceServerId, this.resourceServerSecret);
            post.setHeader("Authorization", (Object)BasicAuthUtil.encodeValue(idPass));
        } else if (this.authenticationMethod == ClientAuthenticationMethod.CLIENT_SECRET_POST) {
            params.add(new BasicNameValuePair("client_id", this.resourceServerId));
            params.add(new BasicNameValuePair("client_secret", this.resourceServerSecret));
        }
        params.add(new BasicNameValuePair("token", tokenString));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        SimpleHttpInvoker.Response res = this.httpInvoker.call((HttpUriRequest)post, r -> r.status == 200 || r.status == 400 || r.status == 401);
        if (res.exception != null) {
            if (res.exception instanceof RuntimeException) {
                throw (RuntimeException)res.exception;
            }
            throw new OAuthRuntimeException(res.exception);
        }
        if (res.status != 200) {
            throw new OAuthRuntimeException("Introspection Endpoint return error:" + res.status + " " + res.content);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("response: " + res.content);
            }
            IntroResponse resJson = (IntroResponse)this.objectMapperService.getObjectMapper().readValue(res.content, IntroResponse.class);
            if (!resJson.active) {
                if (logger.isDebugEnabled()) {
                    logger.debug("token is not active: " + String.valueOf(resJson));
                }
                return null;
            }
            if (this.tenantValidationType == TenantValidationType.NAME) {
                if (!ec.getCurrentTenant().getName().equals(resJson.tenant_name)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("mismatch tenant_name: " + String.valueOf(resJson));
                    }
                    return null;
                }
            } else if (this.tenantValidationType == TenantValidationType.ID && (resJson.tenant_id == null || resJson.tenant_id.intValue() != ec.getClientTenantId())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("mismatch tenant_id: " + String.valueOf(resJson));
                }
                return null;
            }
            RemoteAccessToken accessToken = new RemoteAccessToken(tokenString, resJson);
            if (this.reloadUser) {
                String oid = accessToken.getSub();
                AccessTokenAccountHandle dummy = new AccessTokenAccountHandle(oid, accessToken, null);
                User user = UserEntityResolverHolder.userEntityResolver.searchUser((AccountHandle)dummy);
                if (user == null) {
                    return null;
                }
                accessToken.setUser(user);
            }
            return accessToken;
        }
        catch (IOException e) {
            throw new OAuthRuntimeException(res.exception);
        }
    }

    public void inited(OAuthAuthorizationService service, Config config) {
        this.objectMapperService = (WebApiObjectMapperService)ServiceRegistry.getRegistry().getService(WebApiObjectMapperService.class);
        if (this.httpClientConfig == null) {
            this.httpClientConfig = new HttpClientConfig();
            config.addServiceInitListener((ServiceInitListener)this.httpClientConfig);
        }
        this.httpInvoker = new SimpleHttpInvoker(this.httpClientConfig, this.exponentialBackoff);
    }

    public void destroyed() {
        this.httpInvoker = null;
    }

    @Override
    public AccessToken createAccessToken(MetaOAuthClient.OAuthClientRuntime client, String resourceOwnerId, List<String> scopes) {
        throw new UnsupportedOperationException("RemoteOAuthAccessTokenStore cannot support AccessToken creation");
    }

    @Override
    public AccessToken createAccessToken(MetaOAuthClient.OAuthClientRuntime client, RefreshToken refreshToken) {
        throw new UnsupportedOperationException("RemoteOAuthAccessTokenStore cannot support AccessToken creation");
    }

    @Override
    public AccessToken getAccessTokenByUserOid(MetaOAuthClient.OAuthClientRuntime client, String userOid) {
        throw new UnsupportedOperationException("RemoteOAuthAccessTokenStore cannot support getAccessTokenByUserOid");
    }

    @Override
    public RefreshToken getRefreshToken(String tokenString) {
        throw new UnsupportedOperationException("RemoteOAuthAccessTokenStore cannot support getRefreshToken");
    }

    @Override
    public void revokeToken(MetaOAuthClient.OAuthClientRuntime client, String tokenString, String tokenTypeHint) {
        throw new UnsupportedOperationException("RemoteOAuthAccessTokenStore cannot support revokeToken");
    }

    @Override
    public void revokeTokenByUserOid(String userOid) {
        throw new UnsupportedOperationException("RemoteOAuthAccessTokenStore cannot support revokeToken");
    }
}

