/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.report;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.util.TempFile;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.impl.report.ReportingOutputModel;
import org.iplass.mtp.impl.web.template.report.MetaPoiReportOutputLogic;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiReportingOutputModel
implements ReportingOutputModel {
    private static Logger logger = LoggerFactory.getLogger(PoiReportingOutputModel.class);
    private static final String TYPE_SXSSF = "XLSX_SXSSF_POI";
    private Workbook book;
    private String passwordAttributeName;
    private POIFSFileSystem fs;
    private File tempPasswordFile;
    private MetaPoiReportOutputLogic.PoiReportOutputLogicRuntime logicRuntime;

    PoiReportingOutputModel(byte[] binary, String type, String extension) throws Exception {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(binary);){
            this.book = WorkbookFactory.create((InputStream)bis);
            if (TYPE_SXSSF.equals(type)) {
                if (!(this.book instanceof XSSFWorkbook)) {
                    throw new ApplicationException("SXSSF does not support other than XSSF");
                }
                this.book = new SXSSFWorkbook((XSSFWorkbook)this.book);
            }
        }
    }

    public Workbook getBook() {
        return this.book;
    }

    public MetaPoiReportOutputLogic.PoiReportOutputLogicRuntime getLogicRuntime() {
        return this.logicRuntime;
    }

    public void setLogicRuntime(MetaPoiReportOutputLogic.PoiReportOutputLogicRuntime logicRuntime) {
        this.logicRuntime = logicRuntime;
    }

    public String getPasswordAttributeName() {
        return this.passwordAttributeName;
    }

    public void setPasswordAttributeName(String passwordAttributeName) {
        this.passwordAttributeName = passwordAttributeName;
    }

    public void write(OutputStream os, String password) throws IOException, InvalidFormatException, GeneralSecurityException {
        if (StringUtil.isEmpty((String)password)) {
            this.book.write(os);
        } else if (this.getBook() instanceof HSSFWorkbook) {
            logger.warn("HSSFWorkbook does not support encryption. IF you want to encryption, change to XSSFWorkbook type.");
            this.getBook().write(os);
        } else {
            this.getPOIFSFileSystem(password).writeFilesystem(os);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.book != null) {
                this.book.close();
                if (this.book instanceof SXSSFWorkbook) {
                    ((SXSSFWorkbook)this.book).dispose();
                }
                this.book = null;
            }
        }
        finally {
            try {
                if (this.fs != null) {
                    this.fs.close();
                    this.fs = null;
                }
            }
            finally {
                if (this.tempPasswordFile != null) {
                    if (!this.tempPasswordFile.delete()) {
                        logger.warn("Fail to delete temporary resource:" + this.tempPasswordFile.getPath());
                    }
                    this.tempPasswordFile = null;
                }
            }
        }
    }

    private POIFSFileSystem getPOIFSFileSystem(String password) throws IOException, InvalidFormatException, GeneralSecurityException {
        if (this.fs != null) {
            return this.fs;
        }
        this.tempPasswordFile = TempFile.createTempFile((String)"tmp", (String)".tmp");
        try (FileOutputStream fos = new FileOutputStream(this.tempPasswordFile);){
            this.book.write((OutputStream)fos);
        }
        this.fs = new POIFSFileSystem();
        EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
        Encryptor enc = info.getEncryptor();
        enc.confirmPassword(password);
        try (OPCPackage opc = OPCPackage.open((File)this.tempPasswordFile, (PackageAccess)PackageAccess.READ_WRITE);
             OutputStream encos = enc.getDataStream(this.fs);){
            opc.save(encos);
        }
        return this.fs;
    }
}

