/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.report;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.report.ReportingEngine;
import org.iplass.mtp.impl.report.ReportingEngineService;
import org.iplass.mtp.impl.report.ReportingType;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.web.template.report.definition.OutputFileType;

public class ReportingEngineServiceImpl
implements ReportingEngineService {
    private ReportingEngine[] reportingEngines;

    public void init(Config config) {
        List reportingEngineList = config.getBeans("repotingEngine");
        if (reportingEngineList != null) {
            this.reportingEngines = reportingEngineList.toArray(new ReportingEngine[reportingEngineList.size()]);
        }
    }

    public void destroy() {
    }

    @Override
    public ReportingEngine createReportingEngine(String type) throws Exception {
        ReportingEngine repEngine = null;
        for (ReportingEngine reportingEngine : this.reportingEngines) {
            if (!reportingEngine.getReportingType().getName().equals(type)) continue;
            repEngine = reportingEngine;
            break;
        }
        return repEngine;
    }

    @Override
    public List<OutputFileType> getOutputFileTypeList(String type) {
        ArrayList<OutputFileType> outputFileTypeList = new ArrayList<OutputFileType>();
        for (ReportingEngine reportingEngine : this.reportingEngines) {
            if (!reportingEngine.getReportingType().getName().equals(type)) continue;
            for (String supportFile : reportingEngine.getSupportFiles()) {
                outputFileTypeList.add(OutputFileType.convertOutputFileType(supportFile));
            }
            break;
        }
        return outputFileTypeList;
    }

    @Override
    public List<ReportingType> getReportTypeList() {
        ArrayList<ReportingType> reportTypeList = new ArrayList<ReportingType>();
        for (ReportingEngine reportingEngine : this.reportingEngines) {
            reportTypeList.add(reportingEngine.getReportingType());
        }
        return reportTypeList;
    }
}

