/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingRuntimeException;
import org.iplass.mtp.impl.web.actionmapping.Result;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.actionmapping.definition.result.RedirectResultDefinition;
import org.iplass.mtp.web.actionmapping.definition.result.ResultDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectResult
extends Result {
    private static final long serialVersionUID = 5366716507713343514L;
    private static Logger logger = LoggerFactory.getLogger(RedirectResult.class);
    private String redirectPathAttributeName;
    private boolean allowExternalLocation = false;

    public boolean isAllowExternalLocation() {
        return this.allowExternalLocation;
    }

    public void setAllowExternalLocation(boolean allowExternalLocation) {
        this.allowExternalLocation = allowExternalLocation;
    }

    public RedirectResult() {
    }

    public RedirectResult(String cmdStatus, String redirectPathAttributeName, boolean allowExternalLocation) {
        this.setCommandResultStatus(cmdStatus);
        this.redirectPathAttributeName = redirectPathAttributeName;
        this.allowExternalLocation = allowExternalLocation;
    }

    public String getRedirectPathAttributeName() {
        return this.redirectPathAttributeName;
    }

    public void setRedirectPathAttributeName(String redirectPathAttributeName) {
        this.redirectPathAttributeName = redirectPathAttributeName;
    }

    @Override
    public Result.ResultRuntime createRuntime() {
        return new RedirectResultRuntime();
    }

    @Override
    public void applyConfig(ResultDefinition definition) {
        this.fillFrom(definition);
        RedirectResultDefinition def = (RedirectResultDefinition)definition;
        this.redirectPathAttributeName = def.getRedirectPath();
        this.allowExternalLocation = def.isAllowExternalLocation();
    }

    @Override
    public ResultDefinition currentConfig() {
        RedirectResultDefinition definition = new RedirectResultDefinition();
        this.fillTo(definition);
        definition.setRedirectPath(this.redirectPathAttributeName);
        definition.setAllowExternalLocation(this.allowExternalLocation);
        return definition;
    }

    private class RedirectResultRuntime
    extends Result.ResultRuntime {
        private RedirectResultRuntime() {
            super(RedirectResult.this);
        }

        @Override
        public RedirectResult getMetaData() {
            return RedirectResult.this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handle(WebRequestStack requestContext) throws ServletException, IOException {
            String redirectPath = (String)requestContext.getRequestContext().getAttribute(RedirectResult.this.redirectPathAttributeName);
            if (redirectPath == null) {
                throw new ActionMappingRuntimeException("redirectPath can not specify by attributeName:" + RedirectResult.this.redirectPathAttributeName);
            }
            if (!RedirectResult.this.allowExternalLocation && !WebUtil.isValidInternalUrl(redirectPath)) {
                String serverName = requestContext.getRequest().getServerName();
                String redirectServerName = "";
                try {
                    URI uri = new URI(redirectPath);
                    redirectServerName = uri.getHost();
                }
                catch (URISyntaxException e) {
                    throw new ActionMappingRuntimeException("Invalid redirect URL:" + redirectPath, e);
                }
                if (!serverName.equals(redirectServerName)) throw new ActionMappingRuntimeException("Invalid redirect URL:" + redirectPath);
                if (logger.isDebugEnabled()) {
                    logger.debug("redirect to URL:" + redirectPath);
                }
                requestContext.getResponse().sendRedirect(StringUtil.removeLineFeedCode((String)redirectPath));
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("redirect to URL:" + redirectPath);
            }
            requestContext.getResponse().sendRedirect(StringUtil.removeLineFeedCode((String)redirectPath));
        }

        @Override
        public void finallyProcess(WebRequestStack requestContext) {
        }
    }
}

