/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import jakarta.servlet.ServletException;
import java.io.IOException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.actionmapping.Result;
import org.iplass.mtp.impl.web.staticresource.MetaStaticResource;
import org.iplass.mtp.impl.web.staticresource.StaticResourceService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.web.actionmapping.definition.result.ContentDispositionType;
import org.iplass.mtp.web.actionmapping.definition.result.ResultDefinition;
import org.iplass.mtp.web.actionmapping.definition.result.StaticResourceResultDefinition;

public class StaticResourceResult
extends Result {
    private static final long serialVersionUID = -6801751736171646783L;
    private String staticResourceId;
    private String staticResourceName;
    private boolean resolveByName;
    private boolean useContentDisposition;
    private ContentDispositionType contentDispositionType;
    private String entryPathAttributeName;

    public StaticResourceResult() {
    }

    public StaticResourceResult(String cmdStatus, boolean resolveByName, String idOrName) {
        this.setCommandResultStatus(cmdStatus);
        this.resolveByName = resolveByName;
        if (resolveByName) {
            this.staticResourceName = idOrName;
        } else {
            this.staticResourceId = idOrName;
        }
    }

    public String getEntryPathAttributeName() {
        return this.entryPathAttributeName;
    }

    public void setEntryPathAttributeName(String entryPathAttributeName) {
        this.entryPathAttributeName = entryPathAttributeName;
    }

    public String getStaticResourceId() {
        return this.staticResourceId;
    }

    public void setStaticResourceId(String staticResourceId) {
        this.staticResourceId = staticResourceId;
    }

    public String getStaticResourceName() {
        return this.staticResourceName;
    }

    public void setStaticResourceName(String staticResourceName) {
        this.staticResourceName = staticResourceName;
    }

    public boolean isResolveByName() {
        return this.resolveByName;
    }

    public void setResolveByName(boolean resolveByName) {
        this.resolveByName = resolveByName;
    }

    public boolean isUseContentDisposition() {
        return this.useContentDisposition;
    }

    public void setUseContentDisposition(boolean useContentDisposition) {
        this.useContentDisposition = useContentDisposition;
    }

    public ContentDispositionType getContentDispositionType() {
        return this.contentDispositionType;
    }

    public void setContentDispositionType(ContentDispositionType contentDispositionType) {
        this.contentDispositionType = contentDispositionType;
    }

    @Override
    public Result.ResultRuntime createRuntime() {
        return new StaticResourceResultRuntime();
    }

    @Override
    public void applyConfig(ResultDefinition definition) {
        this.fillFrom(definition);
        StaticResourceResultDefinition def = (StaticResourceResultDefinition)definition;
        StaticResourceService service = (StaticResourceService)ServiceRegistry.getRegistry().getService(StaticResourceService.class);
        MetaStaticResource.StaticResourceRuntime srr = (MetaStaticResource.StaticResourceRuntime)service.getRuntimeByName(def.getStaticResourceName());
        if (srr == null) {
            throw new NullPointerException(def.getStaticResourceName() + " not found");
        }
        this.staticResourceId = srr.getMetaData().getId();
        this.resolveByName = false;
        this.useContentDisposition = def.isUseContentDisposition();
        this.contentDispositionType = def.getContentDispositionType();
        this.entryPathAttributeName = def.getEntryPathAttributeName();
    }

    @Override
    public ResultDefinition currentConfig() {
        StaticResourceResultDefinition definition = new StaticResourceResultDefinition();
        this.fillTo(definition);
        StaticResourceService service = (StaticResourceService)ServiceRegistry.getRegistry().getService(StaticResourceService.class);
        MetaStaticResource.StaticResourceRuntime sr = this.resolveByName ? (MetaStaticResource.StaticResourceRuntime)service.getRuntimeByName(this.staticResourceName) : (MetaStaticResource.StaticResourceRuntime)service.getRuntimeById(this.staticResourceId);
        if (sr != null) {
            definition.setStaticResourceName(sr.getMetaData().getName());
        }
        definition.setUseContentDisposition(this.useContentDisposition);
        definition.setContentDispositionType(this.contentDispositionType);
        definition.setEntryPathAttributeName(this.entryPathAttributeName);
        return definition;
    }

    public class StaticResourceResultRuntime
    extends Result.ResultRuntime {
        public StaticResourceResultRuntime() {
            super(StaticResourceResult.this);
        }

        @Override
        public StaticResourceResult getMetaData() {
            return StaticResourceResult.this;
        }

        @Override
        public void finallyProcess(WebRequestStack request) {
        }

        @Override
        public void handle(WebRequestStack request) throws ServletException, IOException {
            RequestContext cmdRequestContext = request.getRequestContext();
            StaticResourceService srs = (StaticResourceService)ServiceRegistry.getRegistry().getService(StaticResourceService.class);
            MetaStaticResource.StaticResourceRuntime sr = StaticResourceResult.this.resolveByName ? (MetaStaticResource.StaticResourceRuntime)srs.getRuntimeByName(StaticResourceResult.this.staticResourceName) : (MetaStaticResource.StaticResourceRuntime)srs.getRuntimeById(StaticResourceResult.this.staticResourceId);
            if (sr == null) {
                if (StaticResourceResult.this.resolveByName) {
                    throw new WebProcessRuntimeException("can not find staticResource... name:" + StaticResourceResult.this.staticResourceName);
                }
                throw new WebProcessRuntimeException("can not find staticResource... id:" + StaticResourceResult.this.staticResourceId);
            }
            String entryPath = null;
            if (sr.isArchive()) {
                entryPath = (String)cmdRequestContext.getAttribute(StaticResourceResult.this.entryPathAttributeName);
                if (entryPath == null) {
                    entryPath = cmdRequestContext.getParam(StaticResourceResult.this.entryPathAttributeName);
                }
                if (entryPath == null) {
                    throw new IllegalArgumentException("entryPath must specify");
                }
            } else {
                entryPath = (String)cmdRequestContext.getAttribute("actionName");
            }
            sr.handle(request, entryPath, StaticResourceResult.this.useContentDisposition, StaticResourceResult.this.contentDispositionType);
        }
    }
}

