/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.impl.lob.Lob;
import org.iplass.mtp.impl.lob.LobHandler;
import org.iplass.mtp.impl.web.RangeHeader;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.actionmapping.Result;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.ResultStreamWriter;
import org.iplass.mtp.web.actionmapping.definition.result.ContentDispositionType;
import org.iplass.mtp.web.actionmapping.definition.result.ResultDefinition;
import org.iplass.mtp.web.actionmapping.definition.result.StreamResultDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamResult
extends Result {
    private static final long serialVersionUID = -6801751736171646783L;
    private static Logger logger = LoggerFactory.getLogger(StreamResult.class);
    private String inputStreamAttributeName;
    private String contentTypeAttributeName = "contentType";
    private String contentLengthAttributeName = "contentLength";
    private boolean useContentDisposition;
    private ContentDispositionType contentDispositionType;
    private String fileNameAttributeName = "fileName";
    private boolean acceptRanges;

    public StreamResult() {
    }

    public StreamResult(String cmdStatus, String inputStreamAttributeName) {
        this.setCommandResultStatus(cmdStatus);
        this.inputStreamAttributeName = inputStreamAttributeName;
    }

    public boolean isAcceptRanges() {
        return this.acceptRanges;
    }

    public void setAcceptRanges(boolean acceptRanges) {
        this.acceptRanges = acceptRanges;
    }

    public String getInputStreamAttributeName() {
        return this.inputStreamAttributeName;
    }

    public void setInputStreamAttributeName(String inputStreamAttributeName) {
        this.inputStreamAttributeName = inputStreamAttributeName;
    }

    public String getContentTypeAttributeName() {
        return this.contentTypeAttributeName;
    }

    public void setContentTypeAttributeName(String contentTypeAttributeName) {
        this.contentTypeAttributeName = contentTypeAttributeName;
    }

    public String getContentLengthAttributeName() {
        return this.contentLengthAttributeName;
    }

    public void setContentLengthAttributeName(String contentLengthAttributeName) {
        this.contentLengthAttributeName = contentLengthAttributeName;
    }

    public boolean isUseContentDisposition() {
        return this.useContentDisposition;
    }

    public void setUseContentDisposition(boolean useContentDisposition) {
        this.useContentDisposition = useContentDisposition;
    }

    public ContentDispositionType getContentDispositionType() {
        return this.contentDispositionType;
    }

    public void setContentDispositionType(ContentDispositionType contentDispositionType) {
        this.contentDispositionType = contentDispositionType;
    }

    public String getFileNameAttributeName() {
        return this.fileNameAttributeName;
    }

    public void setFileNameAttributeName(String fileNameAttributeName) {
        this.fileNameAttributeName = fileNameAttributeName;
    }

    @Override
    public Result.ResultRuntime createRuntime() {
        return new StreamResultRuntime();
    }

    @Override
    public void applyConfig(ResultDefinition definition) {
        this.fillFrom(definition);
        StreamResultDefinition def = (StreamResultDefinition)definition;
        this.inputStreamAttributeName = def.getInputStreamAttributeName();
        this.contentTypeAttributeName = def.getContentTypeAttributeName();
        this.contentLengthAttributeName = def.getContentLengthAttributeName();
        this.useContentDisposition = def.isUseContentDisposition();
        this.contentDispositionType = def.getContentDispositionType();
        this.fileNameAttributeName = def.getFileNameAttributeName();
        this.acceptRanges = def.isAcceptRanges();
    }

    @Override
    public ResultDefinition currentConfig() {
        StreamResultDefinition definition = new StreamResultDefinition();
        this.fillTo(definition);
        definition.setInputStreamAttributeName(this.inputStreamAttributeName);
        definition.setContentTypeAttributeName(this.contentTypeAttributeName);
        definition.setContentLengthAttributeName(this.contentLengthAttributeName);
        definition.setUseContentDisposition(this.useContentDisposition);
        definition.setContentDispositionType(this.contentDispositionType);
        definition.setFileNameAttributeName(this.fileNameAttributeName);
        definition.setAcceptRanges(this.acceptRanges);
        return definition;
    }

    public class StreamResultRuntime
    extends Result.ResultRuntime {
        public StreamResultRuntime() {
            super(StreamResult.this);
        }

        @Override
        public StreamResult getMetaData() {
            return StreamResult.this;
        }

        @Override
        public void finallyProcess(WebRequestStack requestContext) {
            RequestContext cmdRequestContext = requestContext.getRequestContext();
            Object bin = cmdRequestContext.getAttribute(StreamResult.this.inputStreamAttributeName);
            if (bin != null && bin instanceof InputStream) {
                InputStream is = (InputStream)bin;
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warn("InputSteam.close() failed.maybe leak...", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(WebRequestStack requestContext) throws ServletException, IOException {
            block36: {
                RequestContext cmdRequestContext = requestContext.getRequestContext();
                Object bin = cmdRequestContext.getAttribute(StreamResult.this.inputStreamAttributeName);
                if (bin == null) {
                    throw new WebProcessRuntimeException("binaryData is null");
                }
                InputStream is = null;
                String contentType = (String)cmdRequestContext.getAttribute(StreamResult.this.contentTypeAttributeName);
                Lob binData = null;
                Number size = (Number)cmdRequestContext.getAttribute(StreamResult.this.contentLengthAttributeName);
                if (bin instanceof InputStream) {
                    is = (InputStream)bin;
                } else if (bin instanceof byte[]) {
                    is = new ByteArrayInputStream((byte[])bin);
                } else if (bin instanceof BinaryReference) {
                    binData = LobHandler.getInstance((String)"binaryStore").getBinaryData(((BinaryReference)bin).getLobId());
                    is = binData.getBinaryInputStream();
                    if (contentType == null) {
                        contentType = binData.getType();
                    }
                    if (size == null && binData.getSize() > 0L) {
                        size = binData.getSize();
                    }
                }
                boolean doRange = StreamResult.this.acceptRanges && is != null && size != null && !(bin instanceof ResultStreamWriter);
                RangeHeader range = null;
                if (doRange) {
                    range = RangeHeader.getRangeHeader(requestContext, size.longValue());
                }
                try {
                    long contentLength;
                    if (contentType != null) {
                        requestContext.getResponse().setContentType(contentType.replace("\n", "").replace("\r", ""));
                    }
                    long l = contentLength = size == null ? -1L : size.longValue();
                    if (doRange) {
                        contentLength = RangeHeader.writeResponseHeader(requestContext, range, contentLength);
                    }
                    if (contentLength != -1L) {
                        requestContext.getResponse().setHeader("Content-Length", String.valueOf(contentLength));
                    }
                    if (StreamResult.this.useContentDisposition) {
                        String fileName = null;
                        if (StringUtil.isNotEmpty((String)StreamResult.this.fileNameAttributeName)) {
                            fileName = (String)cmdRequestContext.getAttribute(StreamResult.this.fileNameAttributeName);
                        }
                        if (fileName == null && binData != null) {
                            fileName = binData.getName();
                        }
                        if (fileName == null) {
                            fileName = this.getLastActionName(cmdRequestContext);
                        }
                        if (fileName != null) {
                            WebUtil.setContentDispositionHeader(requestContext, StreamResult.this.getContentDispositionType(), fileName);
                        }
                    }
                    long start = 0L;
                    if (logger.isDebugEnabled()) {
                        start = System.currentTimeMillis();
                    }
                    ServletOutputStream os = requestContext.getResponse().getOutputStream();
                    cmdRequestContext.setAttribute("org.iplass.mtp.markUseOutputStream", (Object)"org.iplass.mtp.markUseOutputStream");
                    if (bin instanceof ResultStreamWriter) {
                        try {
                            ((ResultStreamWriter)bin).write((OutputStream)os);
                            os.flush();
                            break block36;
                        }
                        finally {
                            if (logger.isDebugEnabled()) {
                                logger.debug("stream download done.time:" + (System.currentTimeMillis() - start));
                            }
                        }
                    }
                    if (is == null) {
                        throw new WebProcessRuntimeException("input stream is null");
                    }
                    try {
                        RangeHeader.writeResponseBody(is, (OutputStream)os, range);
                    }
                    finally {
                        if (logger.isDebugEnabled()) {
                            logger.debug("stream download done.time:" + (System.currentTimeMillis() - start));
                        }
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            logger.warn("can not close inputstream resource:" + String.valueOf(is), (Throwable)e);
                        }
                    }
                }
            }
        }

        private String getLastActionName(RequestContext cmdRequestContext) {
            String actionName = (String)cmdRequestContext.getAttribute("actionName");
            if (actionName == null) {
                return null;
            }
            if (actionName.contains("/")) {
                return actionName.substring(actionName.lastIndexOf("/") + 1);
            }
            return actionName;
        }
    }
}

