/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.web.ParameterValueMap;
import org.iplass.mtp.impl.web.RequestPath;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.ParamMap;

public class VariableParameterValueMap
implements ParameterValueMap {
    private ParameterValueMap wrapped;
    private MetaActionMapping.ActionMappingRuntime actionMapping;
    private RequestPath reqPath;
    private boolean noSubPath;
    private String subPath;
    private String rawSubPath;
    private String[] fullPaths;
    private String[] subPaths;
    private Map<String, Object> paramMap;

    public VariableParameterValueMap(ParameterValueMap wrapped, RequestPath reqPath, MetaActionMapping.ActionMappingRuntime actionMapping) {
        this.reqPath = reqPath;
        this.wrapped = wrapped;
        this.actionMapping = actionMapping;
    }

    ParameterValueMap getWrapped() {
        return this.wrapped;
    }

    String getSubPath() {
        this.initRawSubPath();
        if (this.noSubPath) {
            return null;
        }
        if (this.subPath == null) {
            this.subPath = this.decodePath(this.rawSubPath);
        }
        return this.subPath;
    }

    private String decodePath(String path) {
        try {
            return URLDecoder.decode(path.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void initRawSubPath() {
        if (!this.noSubPath && this.rawSubPath == null) {
            String path = this.reqPath.getTargetPath(true);
            String actionName = this.actionMapping.getMetaData().getName();
            if (path.length() > actionName.length()) {
                this.rawSubPath = path.substring(actionName.length() + 1);
            } else {
                this.noSubPath = true;
            }
        }
    }

    String[] getFullPaths() {
        if (this.fullPaths == null) {
            String path = this.reqPath.getTargetPath(true);
            this.fullPaths = path.split("/");
            for (int i = 0; i < this.fullPaths.length; ++i) {
                this.fullPaths[i] = this.decodePath(this.fullPaths[i]);
            }
        }
        return this.fullPaths;
    }

    String[] getSubPaths() {
        this.initRawSubPath();
        if (this.subPaths == null) {
            String sp = this.rawSubPath;
            if (sp == null) {
                this.subPaths = new String[0];
            } else {
                this.subPaths = sp.split("/");
                for (int i = 0; i < this.subPaths.length; ++i) {
                    this.subPaths[i] = this.decodePath(this.subPaths[i]);
                }
            }
        }
        return this.subPaths;
    }

    @Override
    public void cleanTempResource() {
        this.wrapped.cleanTempResource();
    }

    @Override
    public Object getParam(String name) {
        List<ParamMap.ParamMapRuntime> pmrList;
        Map<String, List<ParamMap.ParamMapRuntime>> map = this.actionMapping.getParamMapRuntimes();
        if (map != null && (pmrList = map.get(name)) != null) {
            for (ParamMap.ParamMapRuntime pmr : pmrList) {
                if (!pmr.isTarget(this)) continue;
                return pmr.getParam(this);
            }
        }
        return this.wrapped.getParam(name);
    }

    @Override
    public Object[] getParams(String name) {
        List<ParamMap.ParamMapRuntime> pmrList;
        Map<String, List<ParamMap.ParamMapRuntime>> map = this.actionMapping.getParamMapRuntimes();
        if (map != null && (pmrList = map.get(name)) != null) {
            for (ParamMap.ParamMapRuntime pmr : pmrList) {
                if (!pmr.isTarget(this)) continue;
                return pmr.getParams(this);
            }
        }
        return this.wrapped.getParams(name);
    }

    @Override
    public Map<String, Object> getParamMap() {
        if (this.paramMap == null) {
            Map<String, List<ParamMap.ParamMapRuntime>> map = this.actionMapping.getParamMapRuntimes();
            if (map == null) {
                this.paramMap = this.wrapped.getParamMap();
            } else {
                this.paramMap = new HashMap<String, Object>(this.wrapped.getParamMap());
                block0: for (Map.Entry<String, List<ParamMap.ParamMapRuntime>> e : map.entrySet()) {
                    for (ParamMap.ParamMapRuntime pmr : e.getValue()) {
                        if (!pmr.isTarget(this)) continue;
                        Object[] vals = pmr.getParams(this);
                        if (vals == null) continue block0;
                        this.paramMap.put(e.getKey(), vals);
                        continue block0;
                    }
                }
            }
        }
        return this.paramMap;
    }

    @Override
    public Iterator<String> getParamNames() {
        return this.getParamMap().keySet().iterator();
    }

    public boolean hasParamMapDefs() {
        return this.actionMapping.getParamMapRuntimes() != null;
    }
}

