/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping.cache;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.Locale;
import org.iplass.mtp.impl.web.actionmapping.cache.ContentCache;
import org.iplass.mtp.impl.web.actionmapping.cache.Header;
import org.iplass.mtp.impl.web.actionmapping.cache.blocks.BinaryContentBlock;
import org.iplass.mtp.impl.web.actionmapping.cache.blocks.TextContentBlock;

public class CachableHttpServletResponse
extends HttpServletResponseWrapper {
    public static final String CONTENT_CACHE_NAME = "org.iplass.mtp.contentCache";
    public static final String CHSR_NAME = "org.iplass.mtp.cachableHttpServletResponse";
    public static final String ACTION_RUNTIME_NAME = "org.iplass.mtp.actionRuntime";
    private static final char[] LINE = System.getProperty("line.separator").toCharArray();
    private ByteArrayOutputStream binaryCache;
    private StringBuilder textCache;
    private boolean isError;
    private boolean isRedirect;
    private ServletOutputStreamWrapper os;
    private PrintWriter pr;
    private boolean doCache;
    private ContentCache currentContentCache;

    public CachableHttpServletResponse(HttpServletResponse response) {
        super(response);
    }

    public boolean isDoCache() {
        return this.doCache;
    }

    public void setDoCache(boolean doCache) {
        this.doCache = doCache;
    }

    public void setCurrentContentCache(ContentCache cc) {
        this.currentContentCache = cc;
    }

    public ContentCache getCurrentContentCache() {
        return this.currentContentCache;
    }

    public void flushToContentCache() throws IOException {
        if (this.doCache) {
            ContentCache contentCache = this.getCurrentContentCache();
            if (this.binaryCache != null && this.binaryCache.size() > 0) {
                BinaryContentBlock bb = new BinaryContentBlock(this.binaryCache.toByteArray());
                contentCache.addContent(bb);
            }
            if (this.textCache != null && this.textCache.length() > 0) {
                TextContentBlock tb = new TextContentBlock(this.textCache.toString());
                contentCache.addContent(tb);
            }
        }
        this.binaryCache = null;
        this.textCache = null;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isRedirect() {
        return this.isRedirect;
    }

    public void addCookie(Cookie cookie) {
        super.addCookie(cookie);
    }

    public void addDateHeader(String name, long date) {
        super.addDateHeader(name, date);
        if (this.doCache) {
            this.getCurrentContentCache().addHeader(new Header(name, date, Header.OpeType.ADD, Header.ValType.DATE));
        }
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        if (this.doCache && !"Set-Cookie".equalsIgnoreCase(name)) {
            this.getCurrentContentCache().addHeader(new Header(name, value, Header.OpeType.ADD, Header.ValType.STRING));
        }
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(name, value);
        if (this.doCache) {
            this.getCurrentContentCache().addHeader(new Header(name, value, Header.OpeType.ADD, Header.ValType.INT));
        }
    }

    public boolean containsHeader(String name) {
        return super.containsHeader(name);
    }

    public String encodeRedirectURL(String url) {
        return super.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        return super.encodeURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        super.sendError(sc, msg);
        this.isError = true;
    }

    public void sendError(int sc) throws IOException {
        super.sendError(sc);
        this.isError = true;
    }

    public void sendRedirect(String location) throws IOException {
        super.sendRedirect(location);
        this.isRedirect = true;
    }

    public void setDateHeader(String name, long date) {
        super.setDateHeader(name, date);
        if (this.doCache) {
            this.getCurrentContentCache().addHeader(new Header(name, date, Header.OpeType.SET, Header.ValType.DATE));
        }
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        if (this.doCache && !"Set-Cookie".equalsIgnoreCase(name)) {
            this.getCurrentContentCache().addHeader(new Header(name, value, Header.OpeType.SET, Header.ValType.STRING));
        }
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        if (this.doCache) {
            this.getCurrentContentCache().addHeader(new Header(name, value, Header.OpeType.SET, Header.ValType.INT));
        }
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        if (this.doCache) {
            this.getCurrentContentCache().setHttpStatus(sc);
        }
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
    }

    public int getBufferSize() {
        return super.getBufferSize();
    }

    public String getCharacterEncoding() {
        return super.getCharacterEncoding();
    }

    public String getContentType() {
        return super.getContentType();
    }

    public Locale getLocale() {
        return super.getLocale();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.os = new ServletOutputStreamWrapper(super.getOutputStream());
        }
        return this.os;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.pr == null) {
            this.pr = new PrintWriterWrapper(super.getWriter());
        }
        return this.pr;
    }

    public boolean isCommitted() {
        return super.isCommitted();
    }

    public void reset() {
        super.reset();
        if (this.doCache) {
            this.getCurrentContentCache().resetResponseData();
        }
    }

    public void resetBuffer() {
        super.resetBuffer();
        if (this.doCache) {
            this.getCurrentContentCache().resetContents();
        }
    }

    public void setBufferSize(int size) {
        super.setBufferSize(size);
    }

    public void setCharacterEncoding(String charset) {
        super.setCharacterEncoding(charset);
    }

    public void setContentLength(int len) {
        super.setContentLength(len);
    }

    public void setContentType(String type) {
        super.setContentType(type);
        if (this.doCache) {
            this.getCurrentContentCache().setContentType(type);
        }
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
    }

    private class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private ServletOutputStream actual;

        public ServletOutputStreamWrapper(ServletOutputStream actual) {
            this.actual = actual;
        }

        private OutputStream getOS() {
            if (CachableHttpServletResponse.this.binaryCache == null) {
                CachableHttpServletResponse.this.binaryCache = new ByteArrayOutputStream(8192);
            }
            return CachableHttpServletResponse.this.binaryCache;
        }

        public void write(int b) throws IOException {
            this.actual.write(b);
            if (CachableHttpServletResponse.this.doCache) {
                this.getOS().write(b);
            }
        }

        public void write(byte[] b) throws IOException {
            this.actual.write(b);
            if (CachableHttpServletResponse.this.doCache) {
                this.getOS().write(b);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.actual.write(b, off, len);
            if (CachableHttpServletResponse.this.doCache) {
                this.getOS().write(b, off, len);
            }
        }

        public void flush() throws IOException {
            this.actual.flush();
        }

        public void close() throws IOException {
            this.actual.close();
        }

        public boolean isReady() {
            return this.actual.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.actual.setWriteListener(writeListener);
        }
    }

    private class PrintWriterWrapper
    extends PrintWriter {
        private PrintWriter actual;
        private Formatter formatter;

        private PrintWriterWrapper(PrintWriter actual) {
            super(actual);
            this.actual = actual;
        }

        private StringBuilder getSb() {
            if (CachableHttpServletResponse.this.textCache == null) {
                CachableHttpServletResponse.this.textCache = new StringBuilder(8192);
            }
            return CachableHttpServletResponse.this.textCache;
        }

        @Override
        public void flush() {
            this.actual.flush();
        }

        @Override
        public void write(int c) {
            this.actual.write(c);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(c);
            }
        }

        @Override
        public void write(char[] buf, int off, int len) {
            this.actual.write(buf, off, len);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(buf, off, len);
            }
        }

        @Override
        public void write(char[] buf) {
            this.actual.write(buf);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(buf);
            }
        }

        @Override
        public void write(String s, int off, int len) {
            this.actual.write(s, off, len);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(s, off, off + len);
            }
        }

        @Override
        public void write(String s) {
            this.actual.write(s);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(s);
            }
        }

        @Override
        public void print(boolean b) {
            this.actual.print(b);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(b);
            }
        }

        @Override
        public void print(char c) {
            this.actual.print(c);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(c);
            }
        }

        @Override
        public void print(int i) {
            this.actual.print(i);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(i);
            }
        }

        @Override
        public void print(long l) {
            this.actual.print(l);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(l);
            }
        }

        @Override
        public void print(float f) {
            this.actual.print(f);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(f);
            }
        }

        @Override
        public void print(double d) {
            this.actual.print(d);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(d);
            }
        }

        @Override
        public void print(char[] s) {
            this.actual.print(s);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(s);
            }
        }

        @Override
        public void print(String s) {
            this.actual.print(s);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(s);
            }
        }

        @Override
        public void print(Object obj) {
            this.actual.print(obj);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(obj);
            }
        }

        @Override
        public void println() {
            this.actual.println();
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(LINE);
            }
        }

        @Override
        public void println(boolean x) {
            this.actual.println(x);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(x).append(LINE);
            }
        }

        @Override
        public void println(char x) {
            this.actual.println(x);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(x).append(LINE);
            }
        }

        @Override
        public void println(int x) {
            this.actual.println(x);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(x).append(LINE);
            }
        }

        @Override
        public void println(long x) {
            this.actual.println(x);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(x).append(LINE);
            }
        }

        @Override
        public void println(float x) {
            this.actual.println(x);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(x).append(LINE);
            }
        }

        @Override
        public void println(double x) {
            this.actual.println(x);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(x).append(LINE);
            }
        }

        @Override
        public void println(char[] x) {
            this.actual.println(x);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(x).append(LINE);
            }
        }

        @Override
        public void println(String x) {
            this.actual.println(x);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(x).append(LINE);
            }
        }

        @Override
        public void println(Object x) {
            this.actual.println(x);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(x).append(LINE);
            }
        }

        @Override
        public PrintWriter printf(String format, Object ... args) {
            this.actual.printf(format, args);
            if (CachableHttpServletResponse.this.doCache) {
                if (this.formatter == null || this.formatter.locale() != Locale.getDefault()) {
                    this.formatter = new Formatter(this.getSb());
                }
                this.formatter.format(Locale.getDefault(), format, args);
            }
            return this;
        }

        @Override
        public PrintWriter printf(Locale l, String format, Object ... args) {
            this.actual.printf(l, format, args);
            if (CachableHttpServletResponse.this.doCache) {
                if (this.formatter == null || this.formatter.locale() != l) {
                    this.formatter = new Formatter(this.getSb(), l);
                }
                this.formatter.format(l, format, args);
            }
            return this;
        }

        @Override
        public PrintWriter format(String format, Object ... args) {
            this.actual.format(format, args);
            if (CachableHttpServletResponse.this.doCache) {
                if (this.formatter == null || this.formatter.locale() != Locale.getDefault()) {
                    this.formatter = new Formatter(this.getSb());
                }
                this.formatter.format(Locale.getDefault(), format, args);
            }
            return this;
        }

        @Override
        public PrintWriter format(Locale l, String format, Object ... args) {
            this.actual.format(l, format, args);
            if (CachableHttpServletResponse.this.doCache) {
                if (this.formatter == null || this.formatter.locale() != l) {
                    this.formatter = new Formatter(this.getSb(), l);
                }
                this.formatter.format(l, format, args);
            }
            return this;
        }

        @Override
        public PrintWriter append(CharSequence csq) {
            this.actual.append(csq);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(csq);
            }
            return this;
        }

        @Override
        public PrintWriter append(CharSequence csq, int start, int end) {
            this.actual.append(csq, start, end);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(csq, start, end);
            }
            return this;
        }

        @Override
        public PrintWriter append(char c) {
            this.actual.append(c);
            if (CachableHttpServletResponse.this.doCache) {
                this.getSb().append(c);
            }
            return this;
        }

        @Override
        public void close() {
            this.actual.close();
        }

        @Override
        public boolean checkError() {
            return this.actual.checkError();
        }
    }
}

