/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping.cache;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.WebInvocationImpl;
import org.iplass.mtp.impl.web.actionmapping.cache.ContentBlock;
import org.iplass.mtp.impl.web.actionmapping.cache.ContentCacheContext;
import org.iplass.mtp.impl.web.actionmapping.cache.Header;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaCacheCriteria;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentCache
implements Serializable {
    private static final long serialVersionUID = -1814955389132383329L;
    private static Logger logger = LoggerFactory.getLogger(ContentCache.class);
    private final String key;
    private final String actionName;
    private final String lang;
    private final long creationTime;
    private Integer httpStatus;
    private String contentType;
    private List<Header> header;
    private String layoutActionName;
    private List<ContentBlock> content;
    private Set<String> relatedEntityName;
    private Set<String> relatedEntityNameAndOid;
    private long expires;
    private String etagBase;

    public ContentCache(String actionName, String lang, String key, long timeTolive) {
        this.actionName = actionName;
        this.lang = lang;
        this.key = key;
        this.creationTime = System.currentTimeMillis();
        this.expires = timeTolive > 0L ? this.creationTime + timeTolive : Long.MAX_VALUE;
        this.etagBase = StringUtil.randomToken();
    }

    public String getEtag(long lastModified, String lang) {
        return "W/\"" + this.etagBase + "-" + lastModified + "-" + lang + "\"";
    }

    public long getLastModified(WebInvocationImpl invocation, ContentCacheContext cc, String lang) {
        long lastModified = this.creationTime;
        if (this.content != null) {
            for (ContentBlock c : this.content) {
                lastModified = c.lastModified(lastModified, invocation, cc, lang);
            }
        }
        if (this.layoutActionName != null && lastModified < Long.MAX_VALUE) {
            MetaActionMapping.ActionMappingRuntime amr = (MetaActionMapping.ActionMappingRuntime)((ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class)).getRuntimeByName(this.layoutActionName);
            if (amr == null) {
                return Long.MAX_VALUE;
            }
            MetaCacheCriteria.CacheCriteriaRuntime ccr = amr.getCacheCriteria();
            if (ccr == null) {
                return Long.MAX_VALUE;
            }
            String key = ccr.createContentCacheKey(invocation.getRequest());
            ContentCache layoutCache = cc.get(this.layoutActionName, lang, key);
            if (layoutCache == null) {
                return Long.MAX_VALUE;
            }
            long layoutLastMod = layoutCache.getLastModified(invocation, cc, lang);
            lastModified = Math.max(lastModified, layoutLastMod);
        }
        return lastModified;
    }

    public Set<String> getRelatedEntityName() {
        return this.relatedEntityName;
    }

    public void setRelatedEntityName(Set<String> relatedEntityName) {
        this.relatedEntityName = relatedEntityName;
    }

    public Set<String> getRelatedEntityNameAndOid() {
        return this.relatedEntityNameAndOid;
    }

    public void setRelatedEntityNameAndOid(Set<String> relatedEntityNameAndOid) {
        this.relatedEntityNameAndOid = relatedEntityNameAndOid;
    }

    public void addRelatedEntity(String entityName, String oid) {
        if (this.relatedEntityName == null) {
            this.relatedEntityName = new HashSet<String>();
        }
        if (this.relatedEntityNameAndOid == null) {
            this.relatedEntityNameAndOid = new HashSet<String>();
        }
        this.relatedEntityName.add(entityName);
        this.relatedEntityNameAndOid.add(entityName + ";" + oid);
    }

    public String getLayoutActionName() {
        return this.layoutActionName;
    }

    public void setLayoutActionName(String layoutActionName) {
        this.layoutActionName = layoutActionName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void resetResponseData() {
        this.httpStatus = null;
        this.contentType = null;
        this.header = null;
        this.content = null;
    }

    public void resetContents() {
        this.content = null;
    }

    public Integer getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public List<Header> getHeader() {
        return this.header;
    }

    public void setHeader(List<Header> header) {
        this.header = header;
    }

    public void addHeader(Header h) {
        if (this.header == null) {
            this.header = new ArrayList<Header>();
        }
        this.header.add(h);
    }

    public List<ContentBlock> getContent() {
        return this.content;
    }

    public void setContent(List<ContentBlock> content) {
        this.content = content;
    }

    public void addContent(ContentBlock contentBlock) {
        if (this.content == null) {
            this.content = new ArrayList<ContentBlock>();
        }
        this.content.add(contentBlock);
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public String getKey() {
        return this.key;
    }

    public String getActionName() {
        return this.actionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(WebInvocationImpl webInvocation) throws IOException, ServletException {
        if (this.getLayoutActionName() == null) {
            this.writeDirect(webInvocation.getRequestStack());
        } else {
            ActionMappingService ams = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
            MetaActionMapping.ActionMappingRuntime layout = (MetaActionMapping.ActionMappingRuntime)ams.getRuntimeByName(this.getLayoutActionName());
            WebRequestStack newStack = null;
            try {
                newStack = new WebRequestStack();
                newStack.setLayoutStack(true);
                newStack.setAttribute("org.iplass.mtp.contentTemplate", this);
                if (layout != null) {
                    layout.executeCommand(newStack);
                }
            }
            finally {
                if (newStack != null) {
                    newStack.finallyProcess();
                }
            }
        }
    }

    public void writeContent(WebRequestStack request) throws IOException, ServletException {
        this.writeDirect(request);
    }

    private void writeDirect(WebRequestStack request) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug("write content from cache:action=" + this.actionName + ", lang=" + this.lang + ", key=" + this.key);
        }
        HttpServletResponse res = request.getResponse();
        if (this.getContentType() != null) {
            res.setContentType(this.getContentType());
        }
        if (this.getHttpStatus() != null) {
            res.setStatus(this.getHttpStatus().intValue());
        }
        if (this.getHeader() != null) {
            for (Header h : this.getHeader()) {
                block0 : switch (h.getOpeType()) {
                    case ADD: {
                        switch (h.getValType()) {
                            case DATE: {
                                res.addDateHeader(h.getName(), ((Long)h.getValue()).longValue());
                                break block0;
                            }
                            case INT: {
                                res.addIntHeader(h.getName(), ((Integer)h.getValue()).intValue());
                                break block0;
                            }
                            case STRING: {
                                res.addHeader(h.getName(), (String)h.getValue());
                                break block0;
                            }
                        }
                        break;
                    }
                    case SET: {
                        switch (h.getValType()) {
                            case DATE: {
                                res.setDateHeader(h.getName(), ((Long)h.getValue()).longValue());
                                break block0;
                            }
                            case INT: {
                                res.setIntHeader(h.getName(), ((Integer)h.getValue()).intValue());
                                break block0;
                            }
                            case STRING: {
                                res.setHeader(h.getName(), (String)h.getValue());
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
        }
        if (this.getContent() != null) {
            for (ContentBlock cb : this.getContent()) {
                cb.writeTo(request);
            }
        }
    }
}

