/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.fileupload;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.SortedSet;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.iplass.mtp.impl.web.fileupload.FileUploadTikaAdapter;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FileUploadTikaAdapterImpl
implements FileUploadTikaAdapter,
ServiceInitListener<Service> {
    private static Logger LOG = LoggerFactory.getLogger(FileUploadTikaAdapterImpl.class);
    private String tikaConfigXml;
    private TikaConfig tikaConfig;
    private Tika tika;

    public void inited(Service service, Config config) {
        this.tikaConfig = this.getTikaConfig(this.tikaConfigXml);
        this.tika = new Tika(this.tikaConfig);
    }

    public void destroyed() {
        this.tika = null;
        this.tikaConfig = null;
    }

    public void setTikaConfigXml(String tikaConfigXml) {
        this.tikaConfigXml = tikaConfigXml;
    }

    @Override
    public String detect(InputStream in, String name) throws IOException {
        return this.tika.detect(in, name);
    }

    @Override
    public FileUploadTikaAdapter.TikaMimeType getMimeType(String type) {
        try {
            MimeType registered = this.tikaConfig.getMimeRepository().getRegisteredMimeType(type);
            if (null != registered) {
                return new TikaMimeTypeImpl(registered);
            }
            LOG.warn("MimeType does not exist. (type = {})", (Object)type);
        }
        catch (MimeTypeException e) {
            LOG.warn("An exception occurred when acquiring MimeType. (type = {})", (Object)type, (Object)e);
        }
        return null;
    }

    @Override
    public FileUploadTikaAdapter.TikaMimeType getParentMimeType(FileUploadTikaAdapter.TikaMimeType type) {
        MediaType mediaType = this.getMediaTypeInner(type);
        MediaType superMediaType = this.tikaConfig.getMediaTypeRegistry().getSupertype(mediaType);
        return null == superMediaType ? null : this.getMimeType(superMediaType.toString());
    }

    @Override
    public boolean hasChild(FileUploadTikaAdapter.TikaMimeType parentType, FileUploadTikaAdapter.TikaMimeType childType) {
        MediaType parentMediaType = this.getMediaTypeInner(parentType);
        MediaType childMediaType = this.getMediaTypeInner(childType);
        SortedSet childs = this.tikaConfig.getMediaTypeRegistry().getChildTypes(parentMediaType);
        return childs.contains(childMediaType);
    }

    private MimeType getMimeTypeInner(FileUploadTikaAdapter.TikaMimeType type) {
        if (type instanceof TikaMimeTypeImpl) {
            return ((TikaMimeTypeImpl)type).mimeType;
        }
        FileUploadTikaAdapter.TikaMimeType t = this.getMimeType(type.getName());
        return null == t ? null : ((TikaMimeTypeImpl)t).mimeType;
    }

    private MediaType getMediaTypeInner(FileUploadTikaAdapter.TikaMimeType type) {
        MimeType mimeType = this.getMimeTypeInner(type);
        return null == mimeType ? null : mimeType.getType();
    }

    private TikaConfig getTikaConfig(String tikaConfigXml) {
        if (StringUtil.isNotBlank((String)tikaConfigXml)) {
            URL resource = FileUploadTikaAdapterImpl.class.getResource(tikaConfigXml);
            try {
                return new TikaConfig(resource);
            }
            catch (IOException | TikaException | SAXException e) {
                throw new ServiceConfigrationException(e);
            }
        }
        return TikaConfig.getDefaultConfig();
    }

    public static class TikaMimeTypeImpl
    implements FileUploadTikaAdapter.TikaMimeType {
        private MimeType mimeType;

        public TikaMimeTypeImpl(MimeType mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public String getName() {
            return this.mimeType.getName();
        }

        @Override
        public List<String> getExtensions() {
            return this.mimeType.getExtensions();
        }

        @Override
        public boolean hasMagic() {
            return this.mimeType.hasMagic();
        }

        @Override
        public boolean matchesMagic(byte[] magic) {
            return this.mimeType.matchesMagic(magic);
        }
    }
}

