/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.interceptors;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.NeedTrustedAuthenticationException;
import org.iplass.mtp.auth.NoPermissionException;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.RequestContextWrapper;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AnonymousUserContext;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginHandler;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginInstruction;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantService;
import org.iplass.mtp.impl.tenant.web.MetaTenantWebInfo;
import org.iplass.mtp.impl.web.ErrorUrlSelector;
import org.iplass.mtp.impl.web.LoginUrlSelector;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.WebInvocationImpl;
import org.iplass.mtp.impl.web.i18n.LangSelector;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.impl.web.template.TemplateService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.actionmapping.definition.HttpMethodType;
import org.iplass.mtp.web.actionmapping.permission.ActionPermission;
import org.iplass.mtp.web.actionmapping.permission.RequestContextActionParameter;
import org.iplass.mtp.web.interceptor.RequestInterceptor;
import org.iplass.mtp.web.interceptor.RequestInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthInterceptor
implements RequestInterceptor,
ServiceInitListener<ActionMappingService> {
    private static Logger logger = LoggerFactory.getLogger(AuthInterceptor.class);
    public static final String LOGOUT_FLAG = "mtp.auth.loggedout";
    public static final String TEMPLATE_AFTER_LOGOUT = "templateAfterLogout";
    public static final String REDIRECT_PATH_AFTER_LOGOUT = "redirectPathAfterLogout";
    public static final String REDIRECT_BY_AUTH_INTERCEPTOR = "mtp.auth.redirectByAuthInterceptor";
    private static final String AUTO_LOGIN_PROCESSED_FLAG = "mtp.auth.AutoLoginProcessed";
    private LangSelector lang = new LangSelector();
    private ActionMappingService amService;
    private WebFrontendService wfService = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
    private AuthService authService = (AuthService)ServiceRegistry.getRegistry().getService(AuthService.class);
    private MetaTenantService metaTenantService = (MetaTenantService)ServiceRegistry.getRegistry().getService(MetaTenantService.class);
    private TemplateService ts = (TemplateService)ServiceRegistry.getRegistry().getService(TemplateService.class);

    public void inited(ActionMappingService service, Config config) {
        this.amService = service;
    }

    public void destroyed() {
    }

    private AuthContextHolder getAuthContextHolder(MetaActionMapping.ActionMappingRuntime action) {
        if (action.getMetaData().isPrivileged()) {
            if (logger.isDebugEnabled()) {
                logger.debug("do as Privileged action:" + action.getMetaData().getName());
            }
            return AuthContextHolder.getAuthContext().privilegedAuthContextHolder();
        }
        return AuthContextHolder.getAuthContext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processAutoLogin(RequestInvocation invocation, AuthService authService) {
        UserContext user = authService.getCurrentSessionUserContext();
        if (user != null && !(user instanceof AnonymousUserContext)) {
            AuthenticationProvider ap = authService.getAuthenticationProvider();
            AutoLoginHandler alh = ap.getAutoLoginHandler();
            if (alh == null) return;
            AutoLoginInstruction inst = alh.handle(invocation.getRequest(), true, user);
            switch (inst.getInstruction()) {
                case DO_AUTH: {
                    try {
                        authService.login(inst.getCredential());
                        alh.handleSuccess(inst, invocation.getRequest(), authService.getCurrentSessionUserContext());
                        return;
                    }
                    catch (ApplicationException e) {
                        Exception he = alh.handleException(inst, e, invocation.getRequest(), true, user);
                        if (he instanceof ApplicationException) {
                            throw (ApplicationException)((Object)he);
                        }
                        if (he != null) {
                            throw new WebProcessRuntimeException("auto login fail. cause:" + String.valueOf(he), he);
                        }
                        if (!logger.isDebugEnabled()) return;
                        logger.debug("auto login fail. cause:" + String.valueOf((Object)e));
                    }
                    return;
                }
                case LOGOUT: {
                    authService.logout();
                    return;
                }
                case ERROR: {
                    authService.logout();
                    throw new ApplicationException(WebResourceBundleUtil.resourceString("auth.Login.noLogin", new Object[0]));
                }
                case THROUGH: {
                    return;
                }
            }
            return;
        }
        block16: for (AuthenticationProvider ap : authService.getAuthenticationProviders()) {
            AutoLoginHandler autoLoginHandler = ap.getAutoLoginHandler();
            if (autoLoginHandler == null) continue;
            AutoLoginInstruction inst = autoLoginHandler.handle(invocation.getRequest(), false, null);
            switch (inst.getInstruction()) {
                case DO_AUTH: {
                    try {
                        authService.login(inst.getCredential());
                        autoLoginHandler.handleSuccess(inst, invocation.getRequest(), authService.getCurrentSessionUserContext());
                        return;
                    }
                    catch (ApplicationException e) {
                        Exception he = autoLoginHandler.handleException(inst, e, invocation.getRequest(), false, null);
                        if (he instanceof ApplicationException) {
                            throw (ApplicationException)((Object)he);
                        }
                        if (he != null) {
                            throw new WebProcessRuntimeException("auto login fail. cause:" + String.valueOf(he), he);
                        }
                        if (!logger.isDebugEnabled()) continue block16;
                        logger.debug("auto login fail. cause:" + String.valueOf((Object)e));
                        continue block16;
                    }
                }
                case LOGOUT: {
                    authService.logout();
                    return;
                }
                case ERROR: {
                    authService.logout();
                    throw new ApplicationException(WebResourceBundleUtil.resourceString("auth.Login.noLogin", new Object[0]));
                }
                case THROUGH: {
                    continue block16;
                }
            }
        }
    }

    @Override
    public void intercept(RequestInvocation invocation) {
        WebInvocationImpl webInvocation = (WebInvocationImpl)invocation;
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        if (ec.getAttribute(AUTO_LOGIN_PROCESSED_FLAG) == null) {
            try {
                ec.setAttribute(AUTO_LOGIN_PROCESSED_FLAG, (Object)true, false);
                this.processAutoLogin(webInvocation, this.authService);
            }
            catch (ApplicationException e) {
                invocation.getRequest().setAttribute("mtp.web.exception", (Object)e);
                try {
                    this.showLoginForm(webInvocation, this.wfService);
                }
                catch (ServletException | IOException ee) {
                    throw new WebProcessRuntimeException("can not forword to login form:" + ee.getMessage(), ee);
                }
                return;
            }
        }
        AuthContextHolder account = this.getAuthContextHolder(webInvocation.getAction());
        this.authService.doSecuredAction(account, () -> {
            boolean isPermitted;
            this.lang.selectLangByUser(webInvocation.getRequest(), ExecuteContext.getCurrentContext());
            if (webInvocation.getAction().getMetaData().isPublicAction()) {
                isPermitted = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("do as public action:" + webInvocation.getAction().getMetaData().getName());
                }
            } else {
                ActionPermission permission = new ActionPermission(invocation.getActionName(), new RequestContextActionParameter(invocation.getRequest()));
                isPermitted = account.checkPermission((Permission)permission);
            }
            if (!isPermitted) {
                if (webInvocation.isInclude()) {
                    return null;
                }
                if (account.getUserContext() instanceof AnonymousUserContext) {
                    try {
                        this.showLoginForm(webInvocation, this.wfService);
                    }
                    catch (ServletException e) {
                        throw new WebProcessRuntimeException("can not forword to login form:" + e.getMessage(), e);
                    }
                    catch (IOException e) {
                        throw new WebProcessRuntimeException("can not forword to login form:" + e.getMessage(), e);
                    }
                }
                try {
                    this.showPermissionError(webInvocation, this.wfService);
                }
                catch (ServletException e) {
                    throw new WebProcessRuntimeException("can not forword to permission error page:" + e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new WebProcessRuntimeException("can not forword to permission error page:" + e.getMessage(), e);
                }
                return null;
            }
            try {
                if (webInvocation.getAction().getMetaData().isNeedTrustedAuthenticate() && !this.authService.checkCurrentSessionTrusted().isTrusted()) {
                    throw new NeedTrustedAuthenticationException();
                }
                invocation.proceedRequest();
                return null;
            }
            catch (NeedTrustedAuthenticationException ne) {
                if (account.getUserContext() instanceof AnonymousUserContext) {
                    try {
                        this.showLoginForm(webInvocation, this.wfService);
                    }
                    catch (ServletException e) {
                        throw new WebProcessRuntimeException("can not forword to login form:" + e.getMessage(), e);
                    }
                    catch (IOException e) {
                        throw new WebProcessRuntimeException("can not forword to login form:" + e.getMessage(), e);
                    }
                }
                try {
                    this.showReAuthForm(webInvocation, this.authService);
                }
                catch (ServletException e) {
                    throw new WebProcessRuntimeException("can not forword to permission error page:" + e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new WebProcessRuntimeException("can not forword to permission error page:" + e.getMessage(), e);
                }
                return null;
            }
        });
    }

    private void showLoginForm(WebInvocationImpl webInvocation, WebFrontendService wfService) throws ServletException, IOException {
        String loginActionName;
        ExecuteContext exec = ExecuteContext.getCurrentContext();
        if (wfService.isRedirectAfterLogin() && webInvocation.getAction().getRequestRestriction().isAllowedMethod(HttpMethodType.GET.toString())) {
            String reReqPath = this.createReRequestPath(webInvocation.getRequestStack().getRequest());
            webInvocation.getRequest().setAttribute("redirectPath", (Object)reReqPath);
        }
        WebUtil.setCacheControlHeader(webInvocation.getRequestStack(), false, -1L);
        Tenant tenant = exec.getCurrentTenant();
        MetaTenant.MetaTenantHandler handler = this.metaTenantService.getRuntimeByName(tenant.getName());
        MetaTenantWebInfo.MetaTenantWebInfoRuntime twebr = (MetaTenantWebInfo.MetaTenantWebInfoRuntime)handler.getConfigRuntime(MetaTenantWebInfo.MetaTenantWebInfoRuntime.class);
        RequestContextWrapper request = new RequestContextWrapper(webInvocation.getRequest(), RequestContextWrapper.Mode.SHARED);
        String string = loginActionName = twebr != null ? twebr.loginUrlSelector((RequestContext)request, webInvocation.getRequestStack().getRequestPath().getTargetPath(true)) : null;
        if (StringUtil.isNotEmpty(loginActionName) && this.amService.getByPathHierarchy(loginActionName) == null) {
            logger.error("can not find login action:" + loginActionName + ", so use default login action");
            loginActionName = null;
        }
        if (StringUtil.isEmpty(loginActionName)) {
            LoginUrlSelector defaultSelector = wfService.getLoginUrlSelector();
            if (defaultSelector == null) {
                logger.error("LoginUrlSelector must specified on WebFrontendService");
                throw new SystemException("LoginUrlSelector must specified on WebFrontendService");
            }
            loginActionName = defaultSelector.getLoginActionName((RequestContext)request, webInvocation.getRequestStack().getRequestPath().getTargetPath(true));
            if (StringUtil.isEmpty((String)loginActionName)) {
                throw new NullPointerException("LoginUrlSelector's loginActionName is null or blank");
            }
        }
        try {
            request.setAttribute(REDIRECT_BY_AUTH_INTERCEPTOR, (Object)Boolean.TRUE);
            webInvocation.redirectAction(loginActionName, (RequestContext)request);
        }
        catch (Exception e) {
            logger.error("can not proceed login action:" + loginActionName + ", cause:" + String.valueOf(e), (Throwable)e);
            throw e;
        }
    }

    private void showReAuthForm(WebInvocationImpl webInvocation, AuthService authService) throws ServletException, IOException {
        String tenantReAuthActionName;
        ExecuteContext exec = ExecuteContext.getCurrentContext();
        if (webInvocation.getAction().getRequestRestriction().isAllowedMethod(HttpMethodType.GET.toString())) {
            String reReqPath = this.createReRequestPath(webInvocation.getRequestStack().getRequest());
            webInvocation.getRequest().setAttribute("redirectPath", (Object)reReqPath);
        }
        WebUtil.setCacheControlHeader(webInvocation.getRequestStack(), false, -1L);
        Tenant tenant = exec.getCurrentTenant();
        MetaTenant.MetaTenantHandler handler = this.metaTenantService.getRuntimeByName(tenant.getName());
        MetaTenantWebInfo.MetaTenantWebInfoRuntime twebr = (MetaTenantWebInfo.MetaTenantWebInfoRuntime)handler.getConfigRuntime(MetaTenantWebInfo.MetaTenantWebInfoRuntime.class);
        RequestContextWrapper request = new RequestContextWrapper(webInvocation.getRequest(), RequestContextWrapper.Mode.SHARED);
        String string = tenantReAuthActionName = twebr != null ? twebr.reAuthUrlSelector((RequestContext)request, webInvocation.getRequestStack().getRequestPath().getTargetPath(true)) : null;
        if (StringUtil.isEmpty(tenantReAuthActionName)) {
            LoginUrlSelector defaultSelector = this.wfService.getLoginUrlSelector();
            if (defaultSelector == null) {
                logger.error("LoginUrlSelector must specified on WebFrontendService");
                throw new SystemException("LoginUrlSelector must specified on WebFrontendService");
            }
            tenantReAuthActionName = defaultSelector.getReAuthActionName((RequestContext)request, webInvocation.getRequestStack().getRequestPath().getTargetPath(true));
        }
        request.setAttribute(REDIRECT_BY_AUTH_INTERCEPTOR, (Object)Boolean.TRUE);
        webInvocation.redirectAction(tenantReAuthActionName, (RequestContext)request);
    }

    private void showPermissionError(WebInvocationImpl webInvocation, WebFrontendService wfService) throws ServletException, IOException {
        ExecuteContext exec = ExecuteContext.getCurrentContext();
        WebUtil.setCacheControlHeader(webInvocation.getRequestStack(), false, -1L);
        NoPermissionException exp = new NoPermissionException(WebResourceBundleUtil.resourceString("impl.web.interceptors.AuthInterceptor.noPermission", new Object[0]));
        webInvocation.getRequest().setAttribute("mtp.web.exception", (Object)exp);
        Tenant tenant = exec.getCurrentTenant();
        MetaTenant.MetaTenantHandler handler = this.metaTenantService.getRuntimeByName(tenant.getName());
        MetaTenantWebInfo.MetaTenantWebInfoRuntime twebr = (MetaTenantWebInfo.MetaTenantWebInfoRuntime)handler.getConfigRuntime(MetaTenantWebInfo.MetaTenantWebInfoRuntime.class);
        String tenantPermErrorTemplate = twebr != null ? twebr.errorUrlSelector((Throwable)exp, webInvocation.getRequest(), webInvocation.getRequestStack().getRequestPath().getTargetPath(true)) : null;
        MetaTemplate.TemplateRuntime tr = null;
        if (StringUtil.isNotEmpty(tenantPermErrorTemplate) && (tr = (MetaTemplate.TemplateRuntime)this.ts.getRuntimeByName(tenantPermErrorTemplate)) == null) {
            logger.error("can not find permission error template:" + tenantPermErrorTemplate + ", so use default permission error template");
        }
        if (tr == null) {
            String defaultPermErrorTemplate = null;
            ErrorUrlSelector defaultSelector = wfService.getErrorUrlSelector();
            if (defaultSelector != null) {
                defaultPermErrorTemplate = defaultSelector.getErrorTemplateName((Throwable)exp, webInvocation.getRequest(), webInvocation.getRequestStack().getRequestPath().getTargetPath(true));
            }
            if (defaultPermErrorTemplate != null) {
                tr = (MetaTemplate.TemplateRuntime)this.ts.getRuntimeByName(defaultPermErrorTemplate);
            }
            if (tr == null) {
                logger.error("can not find default permission error template:" + defaultPermErrorTemplate);
            }
        }
        if (tr == null) {
            logger.error("can not find permission error template, so throw exception.");
            throw exp;
        }
        tr.handle(webInvocation.getRequestStack());
    }

    private String createReRequestPath(HttpServletRequest req) {
        StringBuilder buffer = this.createParameter(req);
        if (buffer.length() > 0) {
            buffer.insert(0, "?");
        }
        WebRequestStack reqStack = WebRequestStack.getCurrent();
        buffer.insert(0, reqStack.getRequestPath().getTargetPath());
        buffer.insert(0, reqStack.getRequestPath().getTenantContextPath(req));
        return buffer.toString();
    }

    private StringBuilder createParameter(HttpServletRequest request) {
        Map m = request.getParameterMap();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : m.entrySet()) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            int length = values.length;
            try {
                if (length == 1) {
                    sb.append(key).append("=").append(URLEncoder.encode(values[0], "UTF-8")).append("&");
                    continue;
                }
                if (length == 0) continue;
                for (int i = 0; i < length; ++i) {
                    sb.append(key).append("=").append(URLEncoder.encode(values[i], "UTF-8")).append("&");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return sb;
    }

    @Override
    public void interceptResult(RequestInvocation invocation) {
        RequestContext request = invocation.getRequest();
        Boolean logoutFlag = (Boolean)request.getAttribute(LOGOUT_FLAG);
        if (logoutFlag != null && logoutFlag.booleanValue()) {
            String template = (String)request.getAttribute(TEMPLATE_AFTER_LOGOUT);
            if (template != null) {
                this.doTemplate(template, invocation);
                return;
            }
            String redirectPath = (String)request.getAttribute(REDIRECT_PATH_AFTER_LOGOUT);
            if (redirectPath != null) {
                this.doRedirect(redirectPath, invocation);
                return;
            }
        }
        invocation.proceedResult();
    }

    private void doRedirect(String redirectPath, RequestInvocation invocation) {
        if (logger.isDebugEnabled()) {
            logger.debug("after loggedout redirect URL specified, so redirect to " + redirectPath);
        }
        try {
            ((WebInvocationImpl)invocation).getRequestStack().getResponse().sendRedirect(StringUtil.removeLineFeedCode((String)redirectPath));
        }
        catch (IOException e) {
            throw new WebProcessRuntimeException(e);
        }
    }

    private void doTemplate(String template, RequestInvocation invocation) {
        TemplateService ts;
        MetaTemplate.TemplateRuntime tr;
        if (logger.isDebugEnabled()) {
            logger.debug("after loggedout template specified, so do template:" + template);
        }
        if ((tr = (MetaTemplate.TemplateRuntime)(ts = (TemplateService)ServiceRegistry.getRegistry().getService(TemplateService.class)).getRuntimeByName(template)) == null) {
            throw new WebProcessRuntimeException("after loggedout template specified, but " + template + " not defined.");
        }
        try {
            tr.handle(((WebInvocationImpl)invocation).getRequestStack());
        }
        catch (ServletException | IOException e) {
            throw new WebProcessRuntimeException(e);
        }
    }
}

