/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.staticresource;

import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.web.staticresource.MetaEntryPathTranslator;
import org.iplass.mtp.web.staticresource.EntryPathTranslator;
import org.iplass.mtp.web.staticresource.definition.EntryPathTranslatorDefinition;
import org.iplass.mtp.web.staticresource.definition.ScriptingEntryPathTranslatorDefinition;

public class MetaScriptingEntryPathTranslator
extends MetaEntryPathTranslator {
    private static final long serialVersionUID = -9124402289926024011L;
    private String script;

    public MetaScriptingEntryPathTranslator() {
    }

    public MetaScriptingEntryPathTranslator(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public EntryPathTranslator createEntryPathTranslator(String staticResourceName) {
        ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
        Script s = se.createScript(this.script, "ScriptingEntryPathTranslator_" + staticResourceName);
        if (s.isInstantiateAs(EntryPathTranslator.class)) {
            ScriptContext sc = se.newScriptContext();
            return (EntryPathTranslator)s.createInstanceAs(EntryPathTranslator.class, sc);
        }
        return new ScriptingEntryPathTranslator(this, s, se);
    }

    @Override
    public EntryPathTranslatorDefinition currentConfig() {
        ScriptingEntryPathTranslatorDefinition def = new ScriptingEntryPathTranslatorDefinition();
        def.setScript(this.script);
        return def;
    }

    private class ScriptingEntryPathTranslator
    implements EntryPathTranslator {
        private Script s;
        private ScriptEngine se;

        private ScriptingEntryPathTranslator(MetaScriptingEntryPathTranslator metaScriptingEntryPathTranslator, Script s, ScriptEngine se) {
            this.s = s;
            this.se = se;
        }

        @Override
        public String translate(String requestPath) {
            ScriptContext sc = this.se.newScriptContext();
            sc.setAttribute("requestPath", (Object)requestPath);
            return (String)this.s.eval(sc);
        }
    }
}

