/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.impl.web.WebRequestContext;
import org.iplass.mtp.impl.web.actionmapping.VariableParameterValueMap;
import org.iplass.mtp.impl.web.template.JspTemplateHttpSession;

public class JspTemplateHttpServletRequest
extends HttpServletRequestWrapper {
    private RequestContext requestContext;
    private boolean isMultipart;
    private boolean needCheckParamMap;

    public JspTemplateHttpServletRequest(HttpServletRequest request, RequestContext requestContext) {
        super(request);
        this.requestContext = requestContext;
        this.isMultipart = JakartaServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (requestContext instanceof WebRequestContext && ((WebRequestContext)requestContext).getValueMap() instanceof VariableParameterValueMap) {
            this.needCheckParamMap = ((VariableParameterValueMap)((WebRequestContext)requestContext).getValueMap()).hasParamMapDefs();
        }
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (value == null && (this.isMultipart || this.needCheckParamMap)) {
            value = this.requestContext.getParam(name);
        }
        return value;
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null && (this.isMultipart || this.needCheckParamMap)) {
            values = this.requestContext.getParams(name);
        }
        return values;
    }

    public Map<String, String[]> getParameterMap() {
        if (this.isMultipart) {
            Map paramMap = this.requestContext.getParamMap();
            HashMap<String, String[]> retMap = new HashMap<String, String[]>();
            for (Map.Entry e : paramMap.entrySet()) {
                if (e.getValue() instanceof String[]) {
                    retMap.put((String)e.getKey(), (String[])e.getValue());
                    continue;
                }
                if (!(e.getValue() instanceof UploadFileHandle[])) continue;
                UploadFileHandle[] ufhs = (UploadFileHandle[])e.getValue();
                String[] strs = new String[ufhs.length];
                for (int i = 0; i < strs.length; ++i) {
                    if (ufhs[i] == null) continue;
                    strs[i] = ufhs[i].toString();
                }
                retMap.put((String)e.getKey(), strs);
            }
            Map superMap = super.getParameterMap();
            for (Map.Entry e : superMap.entrySet()) {
                retMap.put((String)e.getKey(), (String[])e.getValue());
            }
            return retMap;
        }
        if (!this.needCheckParamMap) {
            return super.getParameterMap();
        }
        HashMap<String, String[]> retMap = new HashMap<String, String[]>(this.requestContext.getParamMap());
        for (Map.Entry e : super.getParameterMap().entrySet()) {
            retMap.put((String)e.getKey(), (String[])e.getValue());
        }
        return retMap;
    }

    public Enumeration<String> getParameterNames() {
        if (this.isMultipart || this.needCheckParamMap) {
            HashSet<String> names = new HashSet<String>();
            Enumeration pn1 = super.getParameterNames();
            while (pn1.hasMoreElements()) {
                names.add((String)pn1.nextElement());
            }
            Iterator pn2 = this.requestContext.getParamNames();
            while (pn2.hasNext()) {
                names.add((String)pn2.next());
            }
            final Iterator it = names.iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return it.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)it.next();
                }
            };
        }
        return super.getParameterNames();
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = super.getSession(create);
        if (session == null) {
            return null;
        }
        if (this.requestContext != null) {
            return new JspTemplateHttpSession(session, this.requestContext.getSession());
        }
        return session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public Object getAttribute(String name) {
        Object ret = super.getAttribute(name);
        if (ret == null && this.requestContext != null) {
            ret = this.requestContext.getAttribute(name);
        }
        return ret;
    }
}

