/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template.report;

import java.io.Serializable;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.web.template.report.MetaJasperReportType;
import org.iplass.mtp.impl.web.template.report.MetaJxlsReportType;
import org.iplass.mtp.impl.web.template.report.MetaPoiReportType;
import org.iplass.mtp.impl.web.template.report.MetaReportType;
import org.iplass.mtp.web.template.report.definition.JasperReportType;
import org.iplass.mtp.web.template.report.definition.JxlsReportType;
import org.iplass.mtp.web.template.report.definition.LocalizedReportDefinition;
import org.iplass.mtp.web.template.report.definition.PoiReportType;
import org.iplass.mtp.web.template.report.definition.ReportType;

public class MetaLocalizedReport
implements MetaData {
    private static final long serialVersionUID = -1474695966593631014L;
    private String localeName;
    private String fileName;
    private byte[] binary;
    private MetaReportType reportType;

    public MetaLocalizedReport() {
    }

    public MetaLocalizedReport(String localeName, String fileName, byte[] binary, MetaReportType reportType) {
        this.localeName = localeName;
        this.fileName = fileName;
        this.binary = binary;
        this.reportType = reportType;
    }

    public String getLocaleName() {
        return this.localeName;
    }

    public void setLocaleName(String localeName) {
        this.localeName = localeName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public void setBinary(byte[] binary) {
        this.binary = binary;
    }

    public MetaReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(MetaReportType reportType) {
        this.reportType = reportType;
    }

    public MetaLocalizedReport copy() {
        return (MetaLocalizedReport)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public void applyConfig(LocalizedReportDefinition definition) {
        this.localeName = definition.getLocaleName();
        this.fileName = definition.getFileName();
        this.binary = definition.getBinary();
        if (definition.getReportType() != null) {
            ReportType reportType = definition.getReportType();
            if (reportType instanceof JasperReportType) {
                MetaJasperReportType jrt = new MetaJasperReportType();
                jrt.applyConfig(reportType);
                this.reportType = jrt;
            } else if (reportType instanceof PoiReportType) {
                MetaPoiReportType prt = new MetaPoiReportType();
                prt.applyConfig(reportType);
                this.reportType = prt;
            } else if (reportType instanceof JxlsReportType) {
                MetaJxlsReportType jxrt = new MetaJxlsReportType();
                jxrt.applyConfig(reportType);
                this.reportType = jxrt;
            }
        } else {
            this.reportType = null;
        }
    }

    public LocalizedReportDefinition currentConfig() {
        LocalizedReportDefinition definition = new LocalizedReportDefinition();
        definition.setLocaleName(this.getLocaleName());
        definition.setFileName(this.getFileName());
        definition.setBinary(this.getBinary());
        if (this.reportType != null) {
            definition.setReportType(this.reportType.currentConfig());
        }
        return definition;
    }
}

