/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.webapi.definition.EntityWebApiDefinition;

@XmlRootElement
public class MetaEntityWebApi
extends BaseRootMetaData
implements DefinableMetaData<EntityWebApiDefinition> {
    private static final long serialVersionUID = -5517435548233442201L;
    private String definitionId;
    private boolean isInsert;
    private boolean isLoad;
    private boolean isQuery;
    private boolean isUpdate;
    private boolean isDelete;

    public boolean isInsert() {
        return this.isInsert;
    }

    public void setInsert(boolean isInsert) {
        this.isInsert = isInsert;
    }

    public boolean isLoad() {
        return this.isLoad;
    }

    public void setLoad(boolean isLoad) {
        this.isLoad = isLoad;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public void setQuery(boolean isQuery) {
        this.isQuery = isQuery;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public void setDelete(boolean isDelete) {
        this.isDelete = isDelete;
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public MetaDataRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new EntityWebApiHandler();
    }

    public MetaEntityWebApi copy() {
        return (MetaEntityWebApi)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public void applyConfig(EntityWebApiDefinition definition) {
        if (this.id == null) {
            this.id = new KeyGenerator().generateId();
        }
        EntityContext metaContext = EntityContext.getCurrentContext();
        MetaEntity metaEntity = metaContext.getHandlerByName(definition.getName()).getMetaData();
        this.name = metaEntity.getName();
        this.definitionId = metaEntity.getId();
        this.isInsert = definition.isInsert();
        this.isLoad = definition.isLoad();
        this.isQuery = definition.isQuery();
        this.isUpdate = definition.isUpdate();
        this.isDelete = definition.isDelete();
    }

    public EntityWebApiDefinition currentConfig() {
        EntityContext metaContext = EntityContext.getCurrentContext();
        MetaEntity metaEntity = metaContext.getHandlerById(this.definitionId).getMetaData();
        EntityWebApiDefinition definition = new EntityWebApiDefinition();
        definition.setName(metaEntity.getName());
        definition.setInsert(this.isInsert);
        definition.setLoad(this.isLoad);
        definition.setQuery(this.isQuery);
        definition.setUpdate(this.isUpdate);
        definition.setDelete(this.isDelete);
        return definition;
    }

    public class EntityWebApiHandler
    extends BaseMetaDataRuntime {
        EntityWebApiHandler() {
        }

        public MetaEntityWebApi getMetaData() {
            return MetaEntityWebApi.this;
        }
    }
}

