/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.iplass.mtp.command.CommandRuntimeException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.definition.config.CommandConfig;
import org.iplass.mtp.command.interceptor.CommandInterceptor;
import org.iplass.mtp.impl.command.InterceptorService;
import org.iplass.mtp.impl.command.MetaCommand;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptRuntimeException;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.web.CorsConfig;
import org.iplass.mtp.impl.web.ParameterValueMap;
import org.iplass.mtp.impl.web.RequestPath;
import org.iplass.mtp.impl.web.RequestRestriction;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebRequestContext;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.fileupload.MultiPartParameterValueMap;
import org.iplass.mtp.impl.webapi.MetaWebApiParamMap;
import org.iplass.mtp.impl.webapi.MetaWebApiTokenCheck;
import org.iplass.mtp.impl.webapi.WebApiGroovyTemplateBinding;
import org.iplass.mtp.impl.webapi.WebApiInvocationImpl;
import org.iplass.mtp.impl.webapi.WebApiService;
import org.iplass.mtp.impl.webapi.WebApiVariableParameterValueMap;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.webapi.WebApiRuntimeException;
import org.iplass.mtp.webapi.definition.CacheControlType;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.iplass.mtp.webapi.definition.StateType;
import org.iplass.mtp.webapi.definition.WebApiDefinition;
import org.iplass.mtp.webapi.definition.WebApiParamMapDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaWebApi
extends BaseRootMetaData
implements DefinableMetaData<WebApiDefinition> {
    private static final long serialVersionUID = 2590900624234333139L;
    private static Logger logger = LoggerFactory.getLogger(MetaWebApi.class);
    public static final String HEADER_ACCEPT = "Accept";
    public static final String COMMAND_INTERCEPTOR_NAME = "webApi";
    private static final String WILDCARD = "*";
    private MetaCommand command;
    private MetaWebApiParamMap[] webApiParamMap;
    private String[] results;
    private RequestType[] accepts;
    private MethodType[] methods;
    private StateType state = StateType.STATEFUL;
    private boolean supportBearerToken;
    private String[] oauthScopes;
    private CacheControlType cacheControlType;
    private long cacheControlMaxAge = -1L;
    private String restJsonParameterName = null;
    private Class<?> restJsonParameterType = Void.TYPE;
    private String restXmlParameterName = null;
    @XmlElement
    private Boolean privilaged;
    private boolean privileged = false;
    private boolean isPublicWebApi;
    private MetaWebApiTokenCheck tokenCheck;
    private boolean isCheckXRequestedWithHeader = true;
    private boolean synchronizeOnSession;
    private String responseType;
    private String accessControlAllowOrigin;
    private boolean accessControlAllowCredentials;
    private boolean needTrustedAuthenticate;
    private String[] allowRequestContentTypes;
    private Long maxRequestBodySize;
    private Long maxFileSize;

    public Long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(Long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public Long getMaxRequestBodySize() {
        return this.maxRequestBodySize;
    }

    public void setMaxRequestBodySize(Long maxRequestBodySize) {
        this.maxRequestBodySize = maxRequestBodySize;
    }

    public String[] getAllowRequestContentTypes() {
        return this.allowRequestContentTypes;
    }

    public void setAllowRequestContentTypes(String[] allowRequestContentTypes) {
        this.allowRequestContentTypes = allowRequestContentTypes;
    }

    public String[] getOauthScopes() {
        return this.oauthScopes;
    }

    public void setOauthScopes(String[] oauthScopes) {
        this.oauthScopes = oauthScopes;
    }

    public boolean isSupportBearerToken() {
        return this.supportBearerToken;
    }

    public void setSupportBearerToken(boolean supportBearerToken) {
        this.supportBearerToken = supportBearerToken;
    }

    public StateType getState() {
        return this.state;
    }

    public void setState(StateType state) {
        this.state = state;
    }

    public boolean isNeedTrustedAuthenticate() {
        return this.needTrustedAuthenticate;
    }

    public void setNeedTrustedAuthenticate(boolean needTrustedAuthenticate) {
        this.needTrustedAuthenticate = needTrustedAuthenticate;
    }

    public String getAccessControlAllowOrigin() {
        return this.accessControlAllowOrigin;
    }

    public void setAccessControlAllowOrigin(String accessControlAllowOrigin) {
        this.accessControlAllowOrigin = accessControlAllowOrigin;
    }

    public boolean isAccessControlAllowCredentials() {
        return this.accessControlAllowCredentials;
    }

    public void setAccessControlAllowCredentials(boolean accessControlAllowCredentials) {
        this.accessControlAllowCredentials = accessControlAllowCredentials;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public boolean isSynchronizeOnSession() {
        return this.synchronizeOnSession;
    }

    public void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public boolean isCheckXRequestedWithHeader() {
        return this.isCheckXRequestedWithHeader;
    }

    public void setCheckXRequestedWithHeader(boolean isCheckXRequestedWithHeader) {
        this.isCheckXRequestedWithHeader = isCheckXRequestedWithHeader;
    }

    public MetaWebApiTokenCheck getTokenCheck() {
        return this.tokenCheck;
    }

    public void setTokenCheck(MetaWebApiTokenCheck tokenCheck) {
        this.tokenCheck = tokenCheck;
    }

    @Deprecated
    @XmlTransient
    public boolean isPrivilaged() {
        return this.isPrivileged();
    }

    @Deprecated
    public void setPrivilaged(boolean isPrivilaged) {
        this.setPrivileged(isPrivilaged);
    }

    public boolean isPrivileged() {
        if (this.privilaged != null) {
            return this.privilaged;
        }
        return this.privileged;
    }

    public void setPrivileged(boolean isPrivileged) {
        this.privileged = isPrivileged;
        this.privilaged = null;
    }

    public boolean isPublicWebApi() {
        return this.isPublicWebApi;
    }

    public void setPublicWebApi(boolean isPublicWebApi) {
        this.isPublicWebApi = isPublicWebApi;
    }

    public WebApiRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new WebApiRuntime();
    }

    public MetaWebApi copy() {
        return (MetaWebApi)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public MetaCommand getCommand() {
        return this.command;
    }

    public void setCommand(MetaCommand command) {
        this.command = command;
    }

    public MetaWebApiParamMap[] getWebApiParamMap() {
        return this.webApiParamMap;
    }

    public void setWebApiParamMap(MetaWebApiParamMap[] webApiParamMap) {
        this.webApiParamMap = webApiParamMap;
    }

    public void setResults(String[] results) {
        this.results = results;
    }

    public String[] getResults() {
        return this.results;
    }

    public RequestType[] getAccepts() {
        return this.accepts;
    }

    public void setAccepts(RequestType[] accepts) {
        this.accepts = accepts;
    }

    public MethodType[] getMethods() {
        return this.methods;
    }

    public void setMethods(MethodType[] methods) {
        this.methods = methods;
    }

    public String getRestJsonParameterName() {
        return this.restJsonParameterName;
    }

    public void setRestJsonParameterName(String restJsonParameterName) {
        this.restJsonParameterName = restJsonParameterName;
    }

    public Class<?> getRestJsonParameterType() {
        return this.restJsonParameterType;
    }

    public void setRestJsonParameterType(Class<?> restJsonParameterType) {
        this.restJsonParameterType = restJsonParameterType;
    }

    public String getRestXmlParameterName() {
        return this.restXmlParameterName;
    }

    public void setRestXmlParameterName(String restXmlParameterName) {
        this.restXmlParameterName = restXmlParameterName;
    }

    public CacheControlType getCacheControlType() {
        return this.cacheControlType;
    }

    public void setCacheControlType(CacheControlType cacheControlType) {
        this.cacheControlType = cacheControlType;
    }

    public long getCacheControlMaxAge() {
        return this.cacheControlMaxAge;
    }

    public void setCacheControlMaxAge(long cacheControlMaxAge) {
        this.cacheControlMaxAge = cacheControlMaxAge;
    }

    public WebApiDefinition currentConfig() {
        WebApiDefinition definition = new WebApiDefinition();
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setDescription(this.description);
        if (this.command != null) {
            definition.setCommandConfig(this.command.currentConfig());
        }
        if (this.webApiParamMap != null) {
            WebApiParamMapDefinition[] paramMapDefinition = new WebApiParamMapDefinition[this.webApiParamMap.length];
            int i = 0;
            for (MetaWebApiParamMap map : this.webApiParamMap) {
                paramMapDefinition[i] = map.currentConfig();
                ++i;
            }
            definition.setWebApiParamMap(paramMapDefinition);
        }
        if (this.accepts != null) {
            definition.setAccepts(Arrays.copyOf(this.accepts, this.accepts.length));
        }
        if (this.methods != null) {
            definition.setMethods(Arrays.copyOf(this.methods, this.methods.length));
        }
        definition.setState(this.state);
        definition.setSupportBearerToken(this.supportBearerToken);
        definition.setCacheControlType(this.cacheControlType);
        definition.setCacheControlMaxAge(this.cacheControlMaxAge);
        definition.setPrivileged(this.isPrivileged());
        definition.setPublicWebApi(this.isPublicWebApi);
        definition.setCheckXRequestedWithHeader(this.isCheckXRequestedWithHeader);
        if (this.results != null) {
            definition.setResults(Arrays.copyOf(this.results, this.results.length));
        }
        definition.setRestJsonParameterName(this.restJsonParameterName);
        definition.setRestXmlParameterName(this.restXmlParameterName);
        if (this.restJsonParameterType != null && this.restJsonParameterType != Void.TYPE) {
            definition.setRestJsonParameterType(this.restJsonParameterType.getName());
        }
        if (this.tokenCheck != null) {
            definition.setTokenCheck(this.tokenCheck.currentConfig());
        }
        definition.setSynchronizeOnSession(this.synchronizeOnSession);
        definition.setResponseType(this.responseType);
        definition.setAccessControlAllowOrigin(this.accessControlAllowOrigin);
        definition.setAccessControlAllowCredentials(this.accessControlAllowCredentials);
        definition.setNeedTrustedAuthenticate(this.needTrustedAuthenticate);
        if (this.oauthScopes != null) {
            definition.setOauthScopes(Arrays.copyOf(this.oauthScopes, this.oauthScopes.length));
        }
        if (this.allowRequestContentTypes != null) {
            definition.setAllowRequestContentTypes(new String[this.allowRequestContentTypes.length]);
            System.arraycopy(this.allowRequestContentTypes, 0, definition.getAllowRequestContentTypes(), 0, this.allowRequestContentTypes.length);
        }
        definition.setMaxRequestBodySize(this.maxRequestBodySize);
        definition.setMaxFileSize(this.maxFileSize);
        return definition;
    }

    public void applyConfig(WebApiDefinition definition) {
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.description = definition.getDescription();
        this.results = definition.getResults() != null ? Arrays.copyOf(definition.getResults(), definition.getResults().length) : null;
        this.privileged = definition.isPrivileged();
        this.isPublicWebApi = definition.isPublicWebApi();
        this.isCheckXRequestedWithHeader = definition.isCheckXRequestedWithHeader();
        this.accepts = definition.getAccepts() != null ? Arrays.copyOf(definition.getAccepts(), definition.getAccepts().length) : null;
        this.methods = definition.getMethods() != null ? Arrays.copyOf(definition.getMethods(), definition.getMethods().length) : null;
        this.state = definition.getState();
        this.supportBearerToken = definition.isSupportBearerToken();
        this.cacheControlType = definition.getCacheControlType();
        this.cacheControlMaxAge = definition.getCacheControlMaxAge();
        if (definition.getCommandConfig() != null) {
            this.command = MetaCommand.createInstance((CommandConfig)definition.getCommandConfig());
            this.command.applyConfig(definition.getCommandConfig());
        } else {
            this.command = null;
        }
        if (definition.getWebApiParamMap() != null) {
            this.webApiParamMap = new MetaWebApiParamMap[definition.getWebApiParamMap().length];
            int i = 0;
            for (WebApiParamMapDefinition paramDef : definition.getWebApiParamMap()) {
                this.webApiParamMap[i] = new MetaWebApiParamMap();
                this.webApiParamMap[i].applyConfig(paramDef);
                ++i;
            }
        } else {
            this.webApiParamMap = null;
        }
        this.restJsonParameterName = definition.getRestJsonParameterName();
        this.restXmlParameterName = definition.getRestXmlParameterName();
        try {
            this.restJsonParameterType = definition.getRestJsonParameterType() != null ? Class.forName(definition.getRestJsonParameterType()) : null;
        }
        catch (ClassNotFoundException e) {
            throw new CommandRuntimeException(definition.getRestJsonParameterType() + " class not found.", (Throwable)e);
        }
        if (definition.getTokenCheck() != null) {
            this.tokenCheck = new MetaWebApiTokenCheck();
            this.tokenCheck.applyConfig(definition.getTokenCheck());
        } else {
            this.tokenCheck = null;
        }
        this.synchronizeOnSession = definition.isSynchronizeOnSession();
        this.responseType = definition.getResponseType();
        this.accessControlAllowOrigin = definition.getAccessControlAllowOrigin();
        this.accessControlAllowCredentials = definition.isAccessControlAllowCredentials();
        this.needTrustedAuthenticate = definition.isNeedTrustedAuthenticate();
        this.oauthScopes = definition.getOauthScopes() != null ? Arrays.copyOf(definition.getOauthScopes(), definition.getOauthScopes().length) : null;
        if (definition.getAllowRequestContentTypes() != null) {
            this.allowRequestContentTypes = new String[definition.getAllowRequestContentTypes().length];
            System.arraycopy(definition.getAllowRequestContentTypes(), 0, this.allowRequestContentTypes, 0, this.allowRequestContentTypes.length);
        } else {
            this.allowRequestContentTypes = null;
        }
        this.maxRequestBodySize = definition.getMaxRequestBodySize();
        this.maxFileSize = definition.getMaxFileSize();
    }

    public class WebApiRuntime
    extends BaseMetaDataRuntime {
        private MetaCommand.CommandRuntime cmd;
        private HashMap<String, List<MetaWebApiParamMap.WebApiParamMapRuntime>> webApiParamMapRuntimes;
        private GroovyTemplate accessControlAllowOriginTemplate;
        private List<Variant> variants;
        private WebApiService service = (WebApiService)ServiceRegistry.getRegistry().getService(WebApiService.class);
        private InterceptorService is = (InterceptorService)ServiceRegistry.getRegistry().getService(InterceptorService.class);
        private MethodType specificMethod;
        private String parentName;
        private RequestRestriction requestRestrictionRuntime;
        private String corsAllowString;

        public WebApiRuntime() {
            try {
                if (MetaWebApi.this.command != null) {
                    this.cmd = MetaWebApi.this.command.createRuntime();
                }
                if (MetaWebApi.this.webApiParamMap != null) {
                    this.webApiParamMapRuntimes = new HashMap();
                    for (MetaWebApiParamMap p : MetaWebApi.this.webApiParamMap) {
                        MetaWebApiParamMap.WebApiParamMapRuntime pmr = p.createRuntime();
                        List<MetaWebApiParamMap.WebApiParamMapRuntime> pmrList = this.webApiParamMapRuntimes.get(p.getName());
                        if (pmrList == null) {
                            pmrList = new LinkedList<MetaWebApiParamMap.WebApiParamMapRuntime>();
                            this.webApiParamMapRuntimes.put(p.getName(), pmrList);
                        }
                        pmrList.add(pmr);
                    }
                }
                ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                if (MetaWebApi.this.accessControlAllowOrigin != null && MetaWebApi.this.accessControlAllowOrigin.length() != 0) {
                    this.accessControlAllowOriginTemplate = GroovyTemplateCompiler.compile((String)MetaWebApi.this.accessControlAllowOrigin, (String)("AccessControlAllowOriginTemplate" + MetaWebApi.this.getName()), (GroovyScriptEngine)((GroovyScriptEngine)se));
                }
                if (MetaWebApi.this.responseType != null && MetaWebApi.this.responseType.length() != 0) {
                    String[] rtList = MetaWebApi.this.responseType.split(",");
                    MediaType[] mtList = new MediaType[rtList.length];
                    for (int i = 0; i < rtList.length; ++i) {
                        mtList[i] = MediaType.valueOf((String)rtList[i].trim());
                    }
                    this.variants = Variant.mediaTypes((MediaType[])mtList).add().build();
                } else {
                    this.variants = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE}).add().build();
                }
                for (MethodType mt : MethodType.values()) {
                    if (!MetaWebApi.this.name.endsWith(mt.toString()) || MetaWebApi.this.name.charAt(MetaWebApi.this.name.length() - mt.toString().length() - 1) != '/') continue;
                    this.specificMethod = mt;
                    this.parentName = MetaWebApi.this.name.substring(0, MetaWebApi.this.name.length() - mt.toString().length() - 1);
                    break;
                }
                WebFrontendService wfs = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
                MetaWebApi.this.cacheControlType = MetaWebApi.this.getCacheControlType() != null ? MetaWebApi.this.getCacheControlType() : wfs.getDefaultCacheControlType();
                this.requestRestrictionRuntime = wfs.getRequestRestriction(this.getPublicWebApiName(), RequestPath.PathType.REST);
                if (!this.requestRestrictionRuntime.isForce() && (MetaWebApi.this.maxRequestBodySize != null || MetaWebApi.this.maxFileSize != null || MetaWebApi.this.methods != null && MetaWebApi.this.methods.length > 0 || MetaWebApi.this.allowRequestContentTypes != null && MetaWebApi.this.allowRequestContentTypes.length > 0)) {
                    this.requestRestrictionRuntime = this.requestRestrictionRuntime.copy();
                    if (MetaWebApi.this.maxRequestBodySize != null) {
                        this.requestRestrictionRuntime.setMaxBodySize(MetaWebApi.this.maxRequestBodySize);
                    }
                    if (MetaWebApi.this.maxFileSize != null) {
                        this.requestRestrictionRuntime.setMaxFileSize(MetaWebApi.this.maxFileSize);
                    }
                    if (MetaWebApi.this.methods != null && MetaWebApi.this.methods.length > 0) {
                        ArrayList<String> aml = new ArrayList<String>(MetaWebApi.this.methods.length);
                        for (MethodType hmt : MetaWebApi.this.methods) {
                            aml.add(hmt.toString());
                        }
                        this.requestRestrictionRuntime.setAllowMethods(aml);
                    }
                    if (MetaWebApi.this.allowRequestContentTypes != null && MetaWebApi.this.allowRequestContentTypes.length > 0) {
                        this.requestRestrictionRuntime.setAllowContentTypes(Arrays.asList(MetaWebApi.this.allowRequestContentTypes));
                    }
                    this.requestRestrictionRuntime.init();
                }
                this.corsAllowString = this.corsAllowString();
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        private String corsAllowString() {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iterator = this.requestRestrictionRuntime.getAllowMethods().iterator();
            while (iterator.hasNext()) {
                String m;
                switch (m = iterator.next()) {
                    case "GET": {
                        sb.append("GET").append(", ");
                        break;
                    }
                    case "POST": {
                        sb.append("POST").append(", ");
                        break;
                    }
                    case "PUT": {
                        sb.append("PUT").append(", ");
                        break;
                    }
                    case "DELETE": {
                        sb.append("DELETE").append(", ");
                        break;
                    }
                    case "*": {
                        sb.append("GET").append(", ");
                        sb.append("POST").append(", ");
                        sb.append("PUT").append(", ");
                        sb.append("DELETE").append(", ");
                        break;
                    }
                }
            }
            sb.append("OPTIONS");
            return sb.toString();
        }

        public RequestRestriction getRequestRestriction() {
            return this.requestRestrictionRuntime;
        }

        public String getPublicWebApiName() {
            if (this.specificMethod != null) {
                return this.parentName;
            }
            return MetaWebApi.this.name;
        }

        public WebApiRuntime getComprehensiveRuntime() {
            if (this.specificMethod == null) {
                return this;
            }
            return (WebApiRuntime)this.service.getRuntimeByName(this.parentName);
        }

        public List<WebApiRuntime> getIndividualRuntime() {
            ArrayList<WebApiRuntime> rl = new ArrayList<WebApiRuntime>(4);
            for (MethodType mt : MethodType.values()) {
                WebApiRuntime r = (WebApiRuntime)this.service.getRuntimeByName(this.parentName + "/" + mt.toString());
                if (r == null) continue;
                rl.add(r);
            }
            return rl;
        }

        public MethodType getSpecificMethod() {
            return this.specificMethod;
        }

        public List<Variant> getVariants() {
            return this.variants;
        }

        public Map<String, List<MetaWebApiParamMap.WebApiParamMapRuntime>> getWebApiParamMapRuntimes() {
            this.checkState();
            return this.webApiParamMapRuntimes;
        }

        private String getAccessControlAllowOrigin(RequestContext req) {
            if (this.accessControlAllowOriginTemplate != null) {
                StringWriter sw = new StringWriter();
                WebApiGroovyTemplateBinding gtb = new WebApiGroovyTemplateBinding(sw, req);
                try {
                    this.accessControlAllowOriginTemplate.doTemplate((GroovyTemplateBinding)gtb);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException((Throwable)e);
                }
                String acao = sw.toString().trim();
                if (acao.length() == 0 || "null".equals(acao)) {
                    return null;
                }
                return acao;
            }
            return null;
        }

        public boolean isCorsAllowCredentials() {
            CorsConfig cc = this.requestRestrictionRuntime.getCors();
            if (cc == null) {
                cc = this.service.getCors();
            }
            if (!this.requestRestrictionRuntime.isForce() && this.accessControlAllowOriginTemplate != null) {
                return MetaWebApi.this.accessControlAllowCredentials;
            }
            if (cc != null) {
                return cc.isAllowCredentials();
            }
            return false;
        }

        public boolean isCorsAllowOrigin(String origin, RequestContext req) {
            String acao;
            CorsConfig cc = this.requestRestrictionRuntime.getCors();
            if (cc == null) {
                cc = this.service.getCors();
            }
            if (!this.requestRestrictionRuntime.isForce() && (acao = this.getAccessControlAllowOrigin(req)) != null) {
                return this.corsAllowOrign(origin, acao);
            }
            if (cc != null && cc.getAllowOrigin() != null) {
                for (String s : cc.getAllowOrigin()) {
                    if (!this.corsAllowOrign(origin, s)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean corsAllowOrign(String origin, String accessControlAllowOrigin) {
            if (accessControlAllowOrigin != null) {
                if (accessControlAllowOrigin.indexOf(32) >= 0) {
                    String[] accessControlAllowOriginArray;
                    for (String s : accessControlAllowOriginArray = StringUtil.split((String)accessControlAllowOrigin, (char)' ')) {
                        if (!this.isMatchOrigin(origin, s)) continue;
                        return true;
                    }
                } else if (this.isMatchOrigin(origin, accessControlAllowOrigin)) {
                    return true;
                }
            }
            return false;
        }

        private boolean isMatchOrigin(String origin, String accessControlAllowOrigin) {
            return FilenameUtils.wildcardMatch((String)origin, (String)accessControlAllowOrigin);
        }

        public String corsAccessControlAllowMethods() {
            return this.corsAllowString;
        }

        public MetaWebApi getMetaData() {
            return MetaWebApi.this;
        }

        public MetaCommand.CommandRuntime getCommandRuntime() {
            return this.cmd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String executeCommand(WebRequestStack stack, String interceptorName) {
            this.checkState();
            CommandInterceptor[] cmdInterceptors = this.is.getInterceptors(interceptorName);
            RequestContext req = stack.getRequestContext();
            if (req instanceof WebRequestContext) {
                WebRequestContext webRequestContext = (WebRequestContext)req;
                ParameterValueMap currentValueMap = webRequestContext.getValueMap();
                if (currentValueMap instanceof MultiPartParameterValueMap) {
                    ((MultiPartParameterValueMap)currentValueMap).setMaxFileSize(this.requestRestrictionRuntime.maxFileSize());
                }
                if (MetaWebApi.this.webApiParamMap != null) {
                    WebApiVariableParameterValueMap variableValueMap = new WebApiVariableParameterValueMap(currentValueMap, stack.getRequestPath(), this);
                    webRequestContext.setValueMap(variableValueMap);
                }
            }
            if (MetaWebApi.this.synchronizeOnSession) {
                SessionContext sessionContext = req.getSession();
                synchronized (sessionContext) {
                    return new WebApiInvocationImpl(cmdInterceptors, this, req).proceedCommand();
                }
            }
            return new WebApiInvocationImpl(cmdInterceptors, this, req).proceedCommand();
        }

        public void checkXRequestedWith(HttpServletRequest request) {
            if (MetaWebApi.this.isCheckXRequestedWithHeader) {
                for (Map.Entry<String, String> e : this.service.getXRequestedWithMap().entrySet()) {
                    String xRequestedWith = request.getHeader(e.getKey());
                    if (xRequestedWith == null || !xRequestedWith.equals(e.getValue())) continue;
                    return;
                }
                throw new WebApiRuntimeException("X-Requested-With Header( or Custom Header) is needed on WebApi:" + MetaWebApi.this.name);
            }
        }

        public void checkRequestType(RequestType requestAcceptType, HttpServletRequest request) {
            if (MetaWebApi.this.accepts != null) {
                for (RequestType a : MetaWebApi.this.accepts) {
                    if (a != requestAcceptType) continue;
                    return;
                }
            }
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }

        public void checkMethodType(MethodType requestMethodType) {
            this.checkMethodType(requestMethodType.toString());
        }

        public void checkContentType(MediaType contentType) {
            if (contentType == null) {
                return;
            }
            if (!this.requestRestrictionRuntime.isAllowedContentType(contentType)) {
                throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
            }
        }

        public void checkMethodType(String requestMethod) {
            if ("OPTIONS".equals(requestMethod)) {
                return;
            }
            if (!this.requestRestrictionRuntime.isAllowedMethod(requestMethod)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("reject Request. HTTP Method:" + requestMethod + " not allowed for WebAPI:" + MetaWebApi.this.getName());
                }
                throw new WebApplicationException(Response.Status.METHOD_NOT_ALLOWED);
            }
        }

        public boolean isSufficientOAuthScope(List<String> grantedScopes) {
            if (MetaWebApi.this.oauthScopes == null || MetaWebApi.this.oauthScopes.length == 0) {
                return false;
            }
            if (grantedScopes == null || grantedScopes.size() == 0) {
                return false;
            }
            for (String os : MetaWebApi.this.oauthScopes) {
                String[] osSplit;
                if (!(os.indexOf(32) > 0 ? grantedScopes.containsAll(Arrays.asList(osSplit = os.split(" "))) : grantedScopes.contains(os))) continue;
                return true;
            }
            return false;
        }
    }
}

