/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.webapi.jackson.WebApiResponseSerializer;
import org.iplass.mtp.impl.webapi.jaxb.Result;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"status", "resultList", "exceptionType", "exceptionMessage"})
@JsonSerialize(using=WebApiResponseSerializer.class)
public class WebApiResponse {
    private String status;
    @XmlTransient
    private Throwable throwable;
    @XmlTransient
    private Map<String, Object> results;

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void addResult(String key, Object value) {
        if (this.results == null) {
            this.results = new LinkedHashMap<String, Object>();
        }
        this.results.put(key, value);
    }

    public Map<String, Object> getResults() {
        return this.results;
    }

    public void setResults(Map<String, Object> results) {
        this.results = results;
    }

    public Throwable getException() {
        return this.throwable;
    }

    public void setException(Throwable throwable) {
        this.throwable = throwable;
    }

    @XmlElement
    public String getExceptionType() {
        if (this.throwable == null) {
            return null;
        }
        return this.throwable.getClass().getName();
    }

    @XmlElement
    public String getExceptionMessage() {
        if (this.throwable == null) {
            return null;
        }
        return this.throwable.getMessage();
    }

    @XmlElement(name="result")
    public List<Result> getResultList() {
        if (this.results == null) {
            return null;
        }
        ArrayList<Result> res = new ArrayList<Result>(this.results.size());
        for (Map.Entry<String, Object> e : this.results.entrySet()) {
            res.add(new Result(e.getKey(), e.getValue()));
        }
        return res;
    }
}

