/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.command.entity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.function.Predicate;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.entity.fileport.QueryCsvWriteOption;
import org.iplass.mtp.impl.webapi.command.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryJsonWriter
implements AutoCloseable,
Constants {
    private static final Logger logger = LoggerFactory.getLogger(QueryJsonWriter.class);
    private final Query query;
    private final QueryCsvWriteOption option;
    private final EntityManager em;
    private final boolean isCountTotal;
    private ObjectMapper mapper;
    private JsonGenerator gen;

    public QueryJsonWriter(OutputStream out, Query query, boolean isCountTotal, ObjectMapper mapper, JsonFactory jsonFactory) throws IOException {
        this(out, query, isCountTotal, new QueryCsvWriteOption(), mapper, jsonFactory);
    }

    public QueryJsonWriter(OutputStream out, Query query, boolean isCountTotal, QueryCsvWriteOption option, ObjectMapper mapper, JsonFactory jsonFactory) throws IOException {
        this.query = query;
        this.option = option;
        this.isCountTotal = isCountTotal;
        this.mapper = mapper;
        this.em = (EntityManager)ManagerLocator.manager(EntityManager.class);
        this.gen = jsonFactory.createGenerator((Writer)new BufferedWriter(new OutputStreamWriter(out, option.getCharset())));
    }

    public void write() throws IOException {
        this.gen.writeStartObject();
        this.gen.writeStringField("status", "SUCCESS");
        Query optQuery = (Query)this.option.getBeforeSearch().apply(this.query);
        this.gen.writeArrayFieldStart("listHeader");
        for (ValueExpression ve : optQuery.getSelect().getSelectValues()) {
            this.gen.writeString(ve.toString());
        }
        this.gen.writeEndArray();
        this.gen.writeFieldName("list");
        this.gen.writeStartArray();
        int countTotal = this.search(optQuery);
        this.gen.writeEndArray();
        if (this.isCountTotal) {
            this.gen.writeNumberField("count", countTotal);
        }
        this.gen.writeEndObject();
    }

    @Override
    public void close() {
        if (this.gen != null) {
            try {
                this.gen.close();
            }
            catch (IOException e) {
                logger.warn("fail to close QueryJsonWriter resource. check whether resource is leak or not.", (Throwable)e);
            }
            this.gen = null;
        }
    }

    private void writeValues(Object[] values) {
        try {
            this.mapper.writeValue(this.gen, (Object)values);
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
    }

    private int search(final Query optQuery) throws IOException {
        if (this.option.getLimit() > 0) {
            optQuery.setLimit(new Limit(this.option.getLimit()));
        }
        final int[] count = new int[1];
        this.em.search(optQuery, (Predicate)new Predicate<Object[]>(){

            @Override
            public boolean test(Object[] values) {
                QueryJsonWriter.this.option.getAfterSearch().accept(optQuery.copy(), values);
                QueryJsonWriter.this.writeValues(values);
                count[0] = count[0] + 1;
                return true;
            }
        });
        return count[0];
    }
}

