/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.rest;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Request;
import org.iplass.mtp.impl.web.WebRequestContext;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

public class RestRequestContext
extends WebRequestContext {
    static final String WEB_API_RUNTIME_NAME = "mtp.restRequestContext.webApiRuntime";
    static final String MAX_BODY_SIZE = "mtp.restRequestContext.maxBodySize";
    private RequestType requestType;
    private MethodType methodType;
    private Request rsRequest;
    private boolean supportBearerToken;

    public RestRequestContext(ServletContext servletContext, HttpServletRequest req, Request rsRequest, boolean supportBearerToken) {
        super(servletContext, req);
        this.rsRequest = rsRequest;
        switch (rsRequest.getMethod()) {
            case "DELETE": {
                this.methodType = MethodType.DELETE;
                break;
            }
            case "GET": {
                this.methodType = MethodType.GET;
                break;
            }
            case "POST": {
                this.methodType = MethodType.POST;
                break;
            }
            case "PUT": {
                this.methodType = MethodType.PUT;
                break;
            }
        }
        this.supportBearerToken = supportBearerToken;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public boolean supportBearerToken() {
        return this.supportBearerToken;
    }

    public Request rsRequest() {
        return this.rsRequest;
    }

    public MethodType methodType() {
        return this.methodType;
    }

    public RequestType requestType() {
        return this.requestType;
    }

    @Override
    public Object getAttribute(String name) {
        switch (name) {
            case "requestType": {
                return this.requestType;
            }
            case "webApi": {
                return Boolean.TRUE;
            }
            case "action": {
                return null;
            }
            case "httpMethod": {
                return this.methodType;
            }
            case "webApiName": {
                return WebRequestStack.getCurrent().getAttribute("webApiName");
            }
            case "subPath": {
                WebRequestStack stack = WebRequestStack.getCurrent();
                String apiName = (String)stack.getAttribute("webApiName");
                if (apiName == null) {
                    return null;
                }
                return stack.getRequestPath().getTargetSubPath(apiName, true);
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        switch (name) {
            case "requestType": 
            case "webApi": 
            case "action": 
            case "httpMethod": 
            case "webApiName": {
                throw new IllegalArgumentException(name + " is ReadOnly attribute.");
            }
        }
        super.setAttribute(name, value);
    }
}

