/*
 * Decompiled with CFR 0.152.
 */
package com.boundary.config;

import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.KeyValueClient;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.MoreExecutors;
import com.netflix.config.WatchedConfigurationSource;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulWatchedConfigurationSource
extends AbstractExecutionThreadService
implements WatchedConfigurationSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulWatchedConfigurationSource.class);
    private final String rootPath;
    private final KeyValueClient client;
    private final long watchIntervalSeconds;
    private final AtomicReference<ImmutableMap<String, Object>> lastState = new AtomicReference<Object>(null);
    private final AtomicLong latestIndex = new AtomicLong(0L);
    private final String aclToken;
    private List<WatchedUpdateListener> listeners = new CopyOnWriteArrayList<WatchedUpdateListener>();

    private Response<List<GetValue>> getRaw(QueryParams params) {
        return this.client.getKVValues(this.rootPath, this.aclToken, params);
    }

    private Response<List<GetValue>> updateIndex(Response<List<GetValue>> response) {
        if (response != null) {
            this.latestIndex.set(response.getConsulIndex());
        }
        return response;
    }

    public ConsulWatchedConfigurationSource(String rootPath, KeyValueClient client) {
        this(rootPath, client, 10L, TimeUnit.SECONDS);
    }

    public ConsulWatchedConfigurationSource(String rootPath, KeyValueClient client, String aclToken) {
        this(rootPath, client, 10L, TimeUnit.SECONDS, aclToken);
    }

    public ConsulWatchedConfigurationSource(String rootPath, KeyValueClient client, long watchInterval, TimeUnit watchIntervalUnit) {
        this(rootPath, client, watchInterval, watchIntervalUnit, null);
    }

    public ConsulWatchedConfigurationSource(String rootPath, KeyValueClient client, long watchInterval, TimeUnit watchIntervalUnit, String aclToken) {
        this.rootPath = (String)Preconditions.checkNotNull((Object)rootPath);
        this.client = (KeyValueClient)Preconditions.checkNotNull((Object)client);
        this.watchIntervalSeconds = watchIntervalUnit.toSeconds(watchInterval);
        this.aclToken = aclToken;
    }

    private WatchedUpdateResult incrementalResult(final ImmutableMap<String, Object> newState, final ImmutableMap<String, Object> previousState) {
        HashMap added = Maps.newHashMap();
        HashMap removed = Maps.newHashMap();
        HashMap changed = Maps.newHashMap();
        this.addAllKeys((Set<String>)Sets.difference((Set)newState.keySet(), (Set)previousState.keySet()), newState, added);
        this.addAllKeys((Set<String>)Sets.difference((Set)previousState.keySet(), (Set)newState.keySet()), previousState, removed);
        this.addFilteredKeys((Set<String>)Sets.intersection((Set)previousState.keySet(), (Set)newState.keySet()), newState, changed, new Predicate<String>(){

            public boolean apply(String key) {
                return !previousState.get((Object)key).equals(newState.get((Object)key));
            }
        });
        return WatchedUpdateResult.createIncremental((Map)added, (Map)changed, (Map)removed);
    }

    private void addAllKeys(Set<String> keys, ImmutableMap<String, Object> source, Map<String, Object> dest) {
        this.addFilteredKeys(keys, source, dest, new Predicate<String>(){

            public boolean apply(String input) {
                return true;
            }
        });
    }

    private void addFilteredKeys(Set<String> keys, ImmutableMap<String, Object> source, Map<String, Object> dest, Predicate<String> filter) {
        for (String key : keys) {
            if (!filter.apply((Object)key)) continue;
            dest.put(key, source.get((Object)key));
        }
    }

    protected void fireEvent(WatchedUpdateResult result) {
        for (WatchedUpdateListener l : this.listeners) {
            try {
                l.updateConfiguration(result);
            }
            catch (Throwable ex) {
                LOGGER.error("Error invoking WatchedUpdateListener", ex);
            }
        }
    }

    public void addUpdateListener(WatchedUpdateListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeUpdateListener(WatchedUpdateListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public Map<String, Object> getCurrentData() throws Exception {
        return (Map)this.lastState.get();
    }

    @VisibleForTesting
    protected long getLatestIndex() {
        return this.latestIndex.get();
    }

    private ImmutableMap<String, Object> convertToMap(Response<List<GetValue>> kv) {
        if (kv == null || kv.getValue() == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (GetValue gv : (List)kv.getValue()) {
            String value = this.valFunc(gv);
            if (value == null) continue;
            builder.put((Object)this.keyFunc(gv), (Object)value);
        }
        return builder.build();
    }

    private String valFunc(GetValue getValue) {
        String value = getValue.getValue();
        return value != null ? new String(BaseEncoding.base64().decode((CharSequence)value)) : null;
    }

    private String keyFunc(GetValue getValue) {
        return getValue.getKey().substring(this.rootPath.length() + 1);
    }

    protected void run() throws Exception {
        while (this.isRunning()) {
            this.runOnce();
        }
    }

    public void runOnce() throws InterruptedException {
        try {
            Response<List<GetValue>> kvals = this.updateIndex(this.getRaw(this.watchParams()));
            ImmutableMap<String, Object> full = this.convertToMap(kvals);
            WatchedUpdateResult result = this.lastState.get() == null ? WatchedUpdateResult.createFull(full) : this.incrementalResult(full, this.lastState.get());
            this.lastState.set(full);
            this.fireEvent(result);
        }
        catch (Exception e) {
            LOGGER.error("Error watching path, waiting to retry", (Throwable)e);
            Thread.sleep(5000L);
        }
    }

    private QueryParams watchParams() {
        return new QueryParams(this.watchIntervalSeconds, this.latestIndex.get());
    }

    protected Executor executor() {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                Thread thread = MoreExecutors.platformThreadFactory().newThread(command);
                thread.setDaemon(true);
                thread.setName(ConsulWatchedConfigurationSource.this.serviceName());
                thread.start();
            }
        };
    }
}

