/*
 * Decompiled with CFR 0.152.
 */
package gelf4j;

import gelf4j.GelfMessage;
import gelf4j.JsonCodec;
import gelf4j.SyslogLevel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

final class GelfEncoder {
    static final String ID_NAME = "id";
    static final String GELF_VERSION = "1.0";
    static final byte[] CHUNKED_GELF_ID = new byte[]{30, 15};
    static final int MESSAGE_ID_LENGTH = 32;
    static final int SEQUENCE_LENGTH = 2;
    static final int COMPRESSED_MESSAGE_ID_LENGTH = 8;
    static final int COMPRESSED_SEQUENCE_LENGTH = 1;
    static final int COMPRESSED_HEADER_SIZE = CHUNKED_GELF_ID.length + 8 + 1 + 1;
    static final int HEADER_SIZE = CHUNKED_GELF_ID.length + 32 + 2 + 2;
    static final int MAX_PACKET_SIZE = 2048;
    static final int PAYLOAD_THRESHOLD = 2010;
    static final int MAX_SEQ_NUMBER = 255;
    private static final BigDecimal TIME_DIVISOR = new BigDecimal(1000);
    private static final String DEFAULT_FACILITY = "GELF";
    private static final String RUNTIME_ID = ManagementFactory.getRuntimeMXBean().getName();
    private static final AtomicLong c_sequence = new AtomicLong(System.nanoTime());
    private final MessageDigest _messageDigest;
    private final String _hostname;
    private final boolean _compressed;
    private final JsonCodec _codec;

    GelfEncoder(String hostname, boolean compressed, JsonCodec codec) throws Exception {
        this(MessageDigest.getInstance("MD5"), hostname, compressed, codec);
    }

    GelfEncoder(MessageDigest messageDigest, String hostname, boolean compressed, JsonCodec codec) {
        this._messageDigest = messageDigest;
        this._hostname = hostname;
        this._compressed = compressed;
        this._codec = codec;
    }

    List<byte[]> encode(GelfMessage message) {
        String json = this.toJson(message);
        byte[] encodedPayload = null != json ? this.gzip(json) : null;
        return null == encodedPayload ? null : this.createPackets(encodedPayload);
    }

    String toJson(GelfMessage message) {
        String hostname;
        Long line;
        String file;
        Long timestamp;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", GELF_VERSION);
        String shortMessage = message.getShortMessage();
        if (null == shortMessage) {
            return null;
        }
        map.put("short_message", shortMessage);
        String fullMessage = message.getFullMessage();
        if (null != fullMessage) {
            map.put("full_message", fullMessage);
        }
        map.put("timestamp", this.encodeTimestamp(null != (timestamp = message.getJavaTimestamp()) ? timestamp : System.currentTimeMillis()));
        String facility = message.getFacility();
        map.put("facility", null != facility ? facility : DEFAULT_FACILITY);
        SyslogLevel level = message.getLevel();
        if (null != level) {
            map.put("level", level.ordinal());
        }
        if (null != (file = message.getFile())) {
            map.put("file", file);
        }
        if (null != (line = message.getLine())) {
            map.put("line", line);
        }
        map.put("host", null == (hostname = message.getHost()) ? this._hostname : hostname);
        Map<String, Object> fields = message.getAdditionalFields();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            String key = entry.getKey();
            if (key.equals(ID_NAME)) continue;
            map.put("_" + key, entry.getValue());
        }
        return this._codec.toJson(map);
    }

    private String encodeTimestamp(long time) {
        return new BigDecimal(time).divide(TIME_DIVISOR).toPlainString();
    }

    byte[] generateMessageID() {
        byte[] digestString = (this._hostname + c_sequence.incrementAndGet() + RUNTIME_ID).getBytes();
        int messageIdLength = this._compressed ? 8 : 32;
        return Arrays.copyOf(this._messageDigest.digest(digestString), messageIdLength);
    }

    List<byte[]> createPackets(byte[] payload) {
        ArrayList<byte[]> packets = new ArrayList<byte[]>();
        if (payload.length <= 2048) {
            packets.add(payload);
        } else {
            byte[] messageId = this.generateMessageID();
            int fullChunksCount = payload.length / 2010;
            if (fullChunksCount > 255) {
                return null;
            }
            int remainingBytes = payload.length % 2010;
            int chunkCount = fullChunksCount + (remainingBytes != 0 ? 1 : 0);
            int headerSize = this._compressed ? COMPRESSED_HEADER_SIZE : HEADER_SIZE;
            for (int chunk = 0; chunk < fullChunksCount; ++chunk) {
                ByteBuffer buffer = ByteBuffer.allocate(2010 + headerSize);
                buffer.put(CHUNKED_GELF_ID);
                buffer.put(messageId);
                if (!this._compressed) {
                    buffer.put((byte)0);
                }
                buffer.put((byte)chunk);
                if (!this._compressed) {
                    buffer.put((byte)0);
                }
                buffer.put((byte)chunkCount);
                buffer.put(payload, chunk * 2010, 2010);
                packets.add(buffer.array());
            }
            if (remainingBytes > 0) {
                ByteBuffer buffer = ByteBuffer.allocate(remainingBytes + headerSize);
                buffer.put(CHUNKED_GELF_ID);
                buffer.put(messageId);
                if (!this._compressed) {
                    buffer.put((byte)0);
                }
                buffer.put((byte)(chunkCount - 1));
                if (!this._compressed) {
                    buffer.put((byte)0);
                }
                buffer.put((byte)chunkCount);
                buffer.put(payload, fullChunksCount * 2010, remainingBytes);
                packets.add(buffer.array());
            }
        }
        return packets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] gzip(String message) {
        DeflaterOutputStream zipStream = null;
        try {
            ByteArrayOutputStream targetStream = new ByteArrayOutputStream();
            zipStream = new GZIPOutputStream(targetStream);
            zipStream.write(message.getBytes("UTF-8"));
            zipStream.close();
            byte[] zipped = targetStream.toByteArray();
            targetStream.close();
            byte[] byArray = zipped;
            return byArray;
        }
        catch (IOException ioe) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (null != zipStream) {
                    zipStream.close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

