/*
 * Decompiled with CFR 0.152.
 */
package gelf4j.logging;

import gelf4j.GelfConnection;
import gelf4j.GelfMessage;
import gelf4j.GelfMessageUtil;
import gelf4j.GelfTargetConfig;
import gelf4j.SyslogLevel;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class GelfHandler
extends Handler {
    public static final String FIELD_THREAD_ID = "threadId";
    public static final String FIELD_SOURCE_CLASS_NAME = "SourceClassName";
    public static final String FIELD_SOURCE_METHOD_NAME = "SourceMethodName";
    private final GelfTargetConfig _config = new GelfTargetConfig();
    private GelfConnection _connection;

    public GelfHandler() {
        String level;
        String codecClass;
        String compressedChunking;
        String additionalData;
        String additionalFields;
        String port;
        LogManager manager = LogManager.getLogManager();
        String prefix = this.getClass().getName();
        String host = manager.getProperty(prefix + ".host");
        if (null != host) {
            this._config.setHost(host);
        }
        if (null != (port = manager.getProperty(prefix + ".port"))) {
            this._config.setPort(Integer.parseInt(port));
        }
        if (null != (additionalFields = manager.getProperty(prefix + ".additionalFields"))) {
            this._config.setAdditionalFields(additionalFields);
        }
        if (null != (additionalData = manager.getProperty(prefix + ".defaultFields"))) {
            this._config.setDefaultFields(additionalData);
        }
        if (null != (compressedChunking = manager.getProperty(prefix + ".compressedChunking"))) {
            this._config.setCompressedChunking("true".equals(compressedChunking));
        }
        if (null != (codecClass = manager.getProperty(prefix + ".codecClass"))) {
            this._config.setCodecClass(codecClass);
        }
        if (null != (level = manager.getProperty(prefix + ".level"))) {
            this.setLevel(Level.parse(level.trim()));
        } else {
            this.setLevel(Level.INFO);
        }
        String filter = manager.getProperty(prefix + ".filter");
        try {
            if (null != filter) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(filter);
                this.setFilter((Filter)clazz.newInstance());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        if (null != this._connection) {
            try {
                this._connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._connection = null;
        }
    }

    GelfTargetConfig getConfig() {
        return this._config;
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (null == this._connection) {
            try {
                this._connection = this._config.createConnection();
            }
            catch (Exception e) {
                this.reportError("Error initialising gelf connection: " + e.getMessage(), e, 1);
            }
        }
        if (null == this._connection || !this._connection.send(this.makeMessage(record))) {
            this.reportError("Could not send GELF message", null, 1);
        }
    }

    private GelfMessage makeMessage(LogRecord record) {
        String renderedMessage = record.getMessage();
        SyslogLevel level = this.levelToSyslogLevel(record.getLevel());
        GelfMessage message = this._connection.newMessage(level, renderedMessage, record.getMillis());
        for (Map.Entry<String, String> entry : this._config.getAdditionalFields().entrySet()) {
            String fieldName = entry.getValue();
            String key = entry.getKey();
            if ("loggerName".equals(fieldName)) {
                GelfMessageUtil.setValue(message, key, record.getLoggerName());
                continue;
            }
            if (FIELD_THREAD_ID.equals(fieldName)) {
                GelfMessageUtil.setValue(message, key, record.getThreadID());
                continue;
            }
            if ("threadName".equals(fieldName)) {
                GelfMessageUtil.setValue(message, key, Thread.currentThread().getName());
                continue;
            }
            if ("timestampMs".equals(fieldName)) {
                GelfMessageUtil.setValue(message, key, message.getJavaTimestamp());
                continue;
            }
            if ("exception".equals(fieldName)) {
                Throwable throwable = record.getThrown();
                if (null == throwable) continue;
                GelfMessageUtil.setValue(message, key, GelfMessageUtil.extractStacktrace(throwable));
                continue;
            }
            if (FIELD_SOURCE_CLASS_NAME.equals(fieldName)) {
                GelfMessageUtil.setValue(message, key, record.getSourceClassName());
                continue;
            }
            if (!FIELD_SOURCE_METHOD_NAME.equals(fieldName)) continue;
            GelfMessageUtil.setValue(message, key, record.getSourceMethodName());
        }
        return message;
    }

    private SyslogLevel levelToSyslogLevel(Level level) {
        if (Level.SEVERE == level) {
            return SyslogLevel.ERR;
        }
        if (Level.WARNING == level) {
            return SyslogLevel.WARNING;
        }
        if (Level.INFO == level) {
            return SyslogLevel.INFO;
        }
        return SyslogLevel.DEBUG;
    }
}

