/*
 * Decompiled with CFR 0.152.
 */
package gelf4j.sender;

import gelf4j.GelfConnection;
import gelf4j.GelfMessage;
import gelf4j.GelfMessageUtil;
import gelf4j.GelfTargetConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.realityforge.getopt4j.CLArgsParser;
import org.realityforge.getopt4j.CLOption;
import org.realityforge.getopt4j.CLOptionDescriptor;
import org.realityforge.getopt4j.CLUtil;

public class Main {
    private static final int HELP_OPT = 1;
    private static final int HOST_CONFIG_OPT = 104;
    private static final int PORT_CONFIG_OPT = 112;
    private static final int VERBOSE_OPT = 118;
    private static final int UNCOMPRESSED_CHUNKING_OPT = 117;
    private static final int FIELD_OPT = 68;
    private static final int FILE_OPT = 102;
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 1, "print this message and exit"), new CLOptionDescriptor("host", 2, 104, "the host to send the message to. Defaults to the local host."), new CLOptionDescriptor("port", 2, 112, "the port on the server. Defaults to 12201"), new CLOptionDescriptor("file", 2, 102, "file to read message from."), new CLOptionDescriptor("field", 48, 68, "fields added to the message."), new CLOptionDescriptor("verbose", 8, 118, "print verbose message while sending the message."), new CLOptionDescriptor("uncompressed-chunking", 8, 117, "use the uncompressed chunking format used by graylog prior to 0.9.6.")};
    private static final int SUCCESS_EXIT_CODE = 0;
    private static final int ERROR_PARSING_ARGS_EXIT_CODE = 1;
    private static final int ERROR_SENDING_EXIT_CODE = 2;
    private static final GelfTargetConfig c_config = new GelfTargetConfig();
    private static boolean c_verbose;
    private static String c_message;
    private static File c_messageFromFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (!Main.processOptions(args)) {
            System.exit(1);
            return;
        }
        GelfConnection connection = null;
        try {
            if (c_verbose) {
                Main.info("Attempting to transmit message");
            }
            connection = c_config.createConnection();
            GelfMessage message = connection.newMessage();
            if (null != c_message) {
                GelfMessageUtil.setValue(message, "message", c_message);
            }
            if (null != c_messageFromFile) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(c_messageFromFile));
                StringBuilder sb = new StringBuilder();
                while (null != (line = reader.readLine())) {
                    sb.append(line);
                    sb.append("\n");
                }
                GelfMessageUtil.setValue(message, "message", sb.toString());
            }
            if (null == message.getShortMessage()) {
                Main.error("No message specified");
                System.exit(1);
            }
            if (!connection.send(message)) {
                Main.error("Failed to send message: " + message);
                System.exit(2);
            }
            connection.close();
            if (c_verbose) {
                Main.info("Log transmitted");
            }
            System.exit(0);
        }
        catch (Exception e) {
            Main.error("Transmitting message: " + e);
            if (c_verbose) {
                e.printStackTrace(System.out);
            }
            System.exit(2);
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean processOptions(String[] args) {
        CLArgsParser parser = new CLArgsParser(args, OPTIONS);
        if (null != parser.getErrorString()) {
            Main.error(parser.getErrorString());
            return false;
        }
        c_config.getDefaultFields().clear();
        c_config.getAdditionalFields().clear();
        List options = parser.getArguments();
        for (CLOption option : options) {
            switch (option.getId()) {
                case 0: {
                    if (null == c_message) {
                        c_message = option.getArgument();
                        break;
                    }
                    Main.error("Duplicate message specified: " + option.getArgument());
                    return false;
                }
                case 104: {
                    c_config.setHost(option.getArgument());
                    break;
                }
                case 68: {
                    c_config.getDefaultFields().put(option.getArgument(), option.getArgument(1));
                    break;
                }
                case 102: {
                    c_messageFromFile = new File(option.getArgument());
                    break;
                }
                case 112: {
                    String port = option.getArgument();
                    try {
                        c_config.setPort(Integer.parseInt(port));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        Main.error("parsing port: " + port);
                        return false;
                    }
                }
                case 117: {
                    c_config.setCompressedChunking(false);
                    break;
                }
                case 118: {
                    c_verbose = true;
                    break;
                }
                case 1: {
                    Main.printUsage();
                    return false;
                }
            }
        }
        if (null != c_messageFromFile && null != c_message) {
            Main.error("Message file specified as well as message on the command line");
            return false;
        }
        if (c_verbose) {
            Main.info("Server Host: " + c_config.getHost());
            Main.info("Server Port: " + c_config.getPort());
            Main.info("Compressed Chunking Format?: " + c_config.isCompressedChunking());
            Main.info("Default Fields: " + c_config.getDefaultFields());
        }
        return true;
    }

    private static void printUsage() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder msg = new StringBuilder();
        msg.append("java ");
        msg.append(Main.class.getName());
        msg.append(" [options] message");
        msg.append(lineSeparator);
        msg.append("Options: ");
        msg.append(lineSeparator);
        msg.append(CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS).toString());
        Main.info(msg.toString());
    }

    private static void info(String message) {
        System.out.println(message);
    }

    private static void error(String message) {
        System.out.println("Error: " + message);
    }
}

