/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.drowsy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Function;
import org.irenical.drowsy.JdbcFunction;
import org.irenical.drowsy.datasource.DrowsyDataSource;
import org.irenical.drowsy.mapper.BeanMapper;
import org.irenical.drowsy.query.Query;
import org.irenical.drowsy.transaction.JdbcOperation;
import org.irenical.drowsy.transaction.JdbcTransaction;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigFactory;
import org.irenical.lifecycle.LifeCycle;

public class Drowsy
implements LifeCycle {
    private final BeanMapper mapper = new BeanMapper();
    private final Config config;
    private DrowsyDataSource transactionDataSource;
    private DrowsyDataSource operationDataSource;
    private DrowsyDataSource readOnlyDataSource;

    public Drowsy() {
        this(ConfigFactory.getConfig().filterPrefix("jdbc"));
    }

    public Drowsy(Config config) {
        this.config = config;
    }

    @Override
    public void start() {
        this.transactionDataSource = new DrowsyDataSource(this.config){

            @Override
            protected boolean isAutoCommit() {
                return false;
            }
        };
        this.transactionDataSource.start();
        this.operationDataSource = new DrowsyDataSource(this.config){

            @Override
            protected boolean isAutoCommit() {
                return true;
            }

            @Override
            protected boolean isReadOnly() {
                return false;
            }

            @Override
            protected boolean isFlywayBypass() {
                return true;
            }
        };
        this.operationDataSource.start();
        this.readOnlyDataSource = new DrowsyDataSource(this.config){

            @Override
            protected boolean isAutoCommit() {
                return true;
            }

            @Override
            protected boolean isReadOnly() {
                return true;
            }

            @Override
            protected boolean isFlywayBypass() {
                return true;
            }
        };
        this.readOnlyDataSource.start();
    }

    @Override
    public void stop() {
        this.operationDataSource.stop();
        this.transactionDataSource.stop();
        this.readOnlyDataSource.stop();
    }

    @Override
    public boolean isRunning() {
        return this.transactionDataSource.isRunning() && this.operationDataSource.isRunning() && this.readOnlyDataSource.isRunning();
    }

    public <OUTPUT> OUTPUT read(final Query query, final Function<ResultSet, OUTPUT> reader) throws SQLException {
        return new JdbcOperation<OUTPUT>(){

            @Override
            protected OUTPUT execute(Connection connection) throws SQLException {
                PreparedStatement statement = query.createPreparedStatement(connection);
                return reader.apply(statement.executeQuery());
            }
        }.run(this.readOnlyDataSource);
    }

    public <OBJECT> List<OBJECT> read(final Query query, final Class<OBJECT> beanClass) throws SQLException {
        return (List)new JdbcOperation<List<OBJECT>>(){

            @Override
            protected List<OBJECT> execute(Connection connection) throws SQLException {
                PreparedStatement statement = query.createPreparedStatement(connection);
                return Drowsy.this.mapper.map(statement.executeQuery(), beanClass);
            }
        }.run(this.readOnlyDataSource);
    }

    public <OBJECT> List<OBJECT> write(final Query query, final Class<OBJECT> beanClass) throws SQLException {
        return (List)new JdbcOperation<List<OBJECT>>(){

            @Override
            protected List<OBJECT> execute(Connection connection) throws SQLException {
                PreparedStatement statement = query.createPreparedStatement(connection);
                statement.executeUpdate();
                return Drowsy.this.mapper.map(statement.getGeneratedKeys(), beanClass);
            }
        }.run(this.operationDataSource);
    }

    public int write(final Query query) throws SQLException {
        return (Integer)new JdbcOperation<Integer>(){

            @Override
            protected Integer execute(Connection connection) throws SQLException {
                PreparedStatement statement = query.createPreparedStatement(connection);
                return statement.executeUpdate();
            }
        }.run(this.operationDataSource);
    }

    public <OBJECT> OBJECT executeTransaction(final JdbcFunction<OBJECT> transaction) throws SQLException {
        return (OBJECT)new JdbcTransaction<OBJECT>(){

            @Override
            protected OBJECT execute(Connection connection) throws SQLException {
                return transaction.apply(connection);
            }
        }.run(this.transactionDataSource);
    }
}

