/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.drowsy.query;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import org.irenical.drowsy.query.Query;

public class BaseQuery
implements Query {
    private Query.TYPE type;
    private List<Object> parameters;
    private String query;

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public List<Object> getParameters() {
        return this.parameters;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public void setType(Query.TYPE type) {
        this.type = type;
    }

    @Override
    public Query.TYPE getType() {
        return this.type;
    }

    @Override
    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
        PreparedStatement ps = Query.TYPE.CALL.equals((Object)this.type) ? connection.prepareCall(this.query) : (Query.TYPE.INSERT.equals((Object)this.type) ? connection.prepareStatement(this.query, 1) : connection.prepareStatement(this.query));
        this.setParameters(ps, this.parameters, 1);
        return ps;
    }

    private int setParameters(PreparedStatement ps, Collection<Object> parameters, int current) throws SQLException {
        if (parameters != null) {
            for (Object param : parameters) {
                if (param instanceof Collection) {
                    current = this.setParameters(ps, (Collection)param, current);
                    continue;
                }
                this.setInputParameter(ps, current++, param);
            }
        }
        return current;
    }

    private void setInputParameter(PreparedStatement ps, int idx, Object value) throws SQLException {
        if (value instanceof Timestamp) {
            ps.setTimestamp(idx, (Timestamp)value);
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)value;
            GregorianCalendar cal = GregorianCalendar.from(zdt);
            Timestamp t = Timestamp.from(zdt.toInstant());
            ps.setTimestamp(idx, t, cal);
        } else if (value instanceof Time) {
            ps.setTime(idx, (Time)value);
        } else if (value instanceof Date) {
            ps.setDate(idx, (Date)value);
        } else if (value instanceof Enum) {
            ps.setString(idx, value.toString());
        } else if (value instanceof Class) {
            if (!(ps instanceof CallableStatement)) {
                throw new IllegalArgumentException("Invalid parameter type for non-CallableStatement: " + value.getClass());
            }
            this.setOutputParameter((CallableStatement)ps, idx, (Class)value);
            ps.setString(idx, value.toString());
        } else {
            ps.setObject(idx, value);
        }
    }

    private void setOutputParameter(CallableStatement statement, int idx, Class<?> value) throws SQLException {
        if (String.class.getName().equals(value.getName())) {
            statement.registerOutParameter(idx, 12);
        } else if (Float.class.getName().equals(value.getName())) {
            statement.registerOutParameter(idx, 6);
        } else if (Integer.class.getName().equals(value.getName())) {
            statement.registerOutParameter(idx, 4);
        } else if (Timestamp.class.getName().equals(value.getName())) {
            statement.registerOutParameter(idx, 93);
        } else if (Boolean.class.getName().equals(value.getName())) {
            statement.registerOutParameter(idx, 16);
        } else {
            statement.registerOutParameter(idx, 2000);
        }
    }
}

