/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.dumpy;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.irenical.dumpy.api.IJob;
import org.irenical.dumpy.api.IJobProcessor;
import org.irenical.dumpy.impl.ErrorJobProcessor;
import org.irenical.dumpy.impl.LatestJobProcessor;
import org.irenical.dumpy.impl.db.DumpyDB;
import org.irenical.lifecycle.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dumpy
implements LifeCycle,
Consumer<IJob> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dumpy.class);
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);
    private final DumpyDB dumpyDB = new DumpyDB();
    private final IJobProcessor latestJobProcessor = new LatestJobProcessor(this.dumpyDB);
    private final IJobProcessor errorJobProcessor = new ErrorJobProcessor(this.dumpyDB);
    private boolean errorCheckEnabled = true;

    public Dumpy() {
    }

    public Dumpy(boolean errorCheckEnabled) {
        this.errorCheckEnabled = errorCheckEnabled;
    }

    @Override
    public <ERROR extends Exception> void start() throws ERROR {
        this.latestJobProcessor.start();
        this.errorJobProcessor.start();
        this.dumpyDB.start();
    }

    @Override
    public <ERROR extends Exception> void stop() throws ERROR {
        this.latestJobProcessor.stop();
        this.errorJobProcessor.stop();
        this.dumpyDB.stop();
    }

    @Override
    public <ERROR extends Exception> boolean isRunning() throws ERROR {
        return this.latestJobProcessor.isRunning() && this.errorJobProcessor.isRunning() && this.dumpyDB.isRunning();
    }

    @Override
    public void accept(IJob iJob) {
        if (!this.isRunning()) {
            throw new IllegalStateException("dumpy is not started");
        }
        this.executorService.execute(() -> this.latestJobProcessor.accept(iJob));
        if (this.errorCheckEnabled) {
            this.executorService.execute(() -> this.errorJobProcessor.accept(iJob));
        }
        try {
            boolean awaitTermination = false;
            while (!awaitTermination) {
                LOGGER.debug("[ dumpy ] waiting for jobs to finish");
                awaitTermination = this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getLocalizedMessage(), e);
        }
    }
}

