/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.dumpy.impl;

import java.sql.SQLException;
import java.util.List;
import org.irenical.dumpy.api.IJob;
import org.irenical.dumpy.api.IJobProcessor;
import org.irenical.dumpy.api.IStream;
import org.irenical.dumpy.api.IStreamProcessor;
import org.irenical.dumpy.impl.LatestJobProcessor;
import org.irenical.dumpy.impl.db.DumpyDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseJobProcessor
implements IJobProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LatestJobProcessor.class);
    private final IStreamProcessor streamProcessor;
    private boolean isRunning = false;
    protected final DumpyDB dumpyDB;

    public BaseJobProcessor(DumpyDB dumpyDB, IStreamProcessor streamProcessor) {
        this.dumpyDB = dumpyDB;
        this.streamProcessor = streamProcessor;
    }

    @Override
    public <ERROR extends Exception> void start() throws ERROR {
        this.streamProcessor.start();
        this.isRunning = true;
    }

    @Override
    public <ERROR extends Exception> void stop() throws ERROR {
        this.isRunning = false;
        this.streamProcessor.stop();
    }

    @Override
    public <ERROR extends Exception> boolean isRunning() throws ERROR {
        return this.isRunning && this.dumpyDB.isRunning() && this.streamProcessor.isRunning();
    }

    @Override
    public void accept(IJob iJob) throws SQLException {
        if (iJob == null) {
            throw new IllegalArgumentException("no job provided");
        }
        List<IStream> streams = iJob.getStreams();
        if (streams == null || streams.isEmpty()) {
            throw new IllegalArgumentException("no streams provided");
        }
        while (this.isRunning && !Thread.currentThread().isInterrupted()) {
            for (IStream iStream : streams) {
                this.onStreamStart(iJob, iStream);
                try {
                    this.streamProcessor.process(iJob, iStream);
                    this.onStreamEnd(iJob, iStream);
                }
                catch (Exception e) {
                    this.onStreamFail(iJob, iStream, e);
                }
            }
        }
    }

    protected void onStreamStart(IJob iJob, IStream iStream) throws SQLException {
    }

    protected void onStreamEnd(IJob iJob, IStream iStream) {
    }

    protected void onStreamFail(IJob iJob, IStream iStream, Exception e) {
        LOGGER.error(e.getLocalizedMessage(), e);
    }
}

