/*
 * Decompiled with CFR 0.152.
 */
package gelf4j;

import gelf4j.GelfConnection;
import gelf4j.GelfMessageUtil;
import gelf4j.JsonCodec;
import gelf4j.SimpleJsonCodec;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class GelfTargetConfig {
    public static final String FIELD_THREAD_NAME = "threadName";
    public static final String FIELD_TIMESTAMP_PREFIX = "timestamp:";
    public static final String FIELD_TIMESTAMP_MS = "timestampMs";
    public static final String FIELD_LOGGER_NAME = "loggerName";
    public static final String FIELD_EXCEPTION = "exception";
    public static final String FIELD_LEVEL = "level";
    public static final String FIELD_FACILITY = "facility";
    public static final String FIELD_LINE = "line";
    public static final String FIELD_FILE = "file";
    public static final String FIELD_HOST = "host";
    public static final String FIELD_MESSAGE = "message";
    public static final String DEFAULT_JSON_CODEC = "gelf4j.SimpleJsonCodec";
    public static final int DEFAULT_PORT = 12201;
    private String _host;
    private InetAddress _hostAddress;
    private int _port = 12201;
    private boolean _compressedChunking = true;
    private String _codecClass = "gelf4j.SimpleJsonCodec";
    private JsonCodec _codec;
    private String _defaultFieldsJson;
    private final Map<String, Object> _defaultFields;
    private String _additionalFieldsJson;
    private final Map<String, String> _additionalFields;

    public GelfTargetConfig() {
        try {
            this._host = GelfMessageUtil.getLocalHost();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._additionalFields = new HashMap<String, String>();
        this._additionalFields.put(FIELD_EXCEPTION, FIELD_EXCEPTION);
        this._additionalFields.put(FIELD_THREAD_NAME, FIELD_THREAD_NAME);
        this._additionalFields.put(FIELD_LOGGER_NAME, FIELD_LOGGER_NAME);
        this._additionalFields.put(FIELD_TIMESTAMP_MS, FIELD_TIMESTAMP_MS);
        this._defaultFields = new HashMap<String, Object>();
        this._defaultFields.put(FIELD_HOST, this._host);
    }

    public boolean isCompressedChunking() {
        return this._compressedChunking;
    }

    public void setCompressedChunking(boolean compressedChunking) {
        this._compressedChunking = compressedChunking;
    }

    public String getHost() {
        return this._host;
    }

    public InetAddress getHostAddress() {
        if (null == this._hostAddress && null != this._host) {
            try {
                this._hostAddress = InetAddress.getByName(this._host);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this._hostAddress;
    }

    public void setHost(String host) {
        this._host = host;
        this._hostAddress = null;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public GelfConnection createConnection() throws Exception {
        try {
            return new GelfConnection(this);
        }
        catch (Exception e) {
            throw new Exception("Error connecting to GELF host " + this.getHost() + " on port " + this.getPort(), e);
        }
    }

    public String getCodecClass() {
        return this._codecClass;
    }

    public void setCodecClass(String codecClass) {
        this._codecClass = codecClass;
    }

    public Map<String, String> getAdditionalFields() {
        if (null != this._additionalFieldsJson) {
            this._additionalFields.clear();
            for (Map.Entry<String, Object> entry : this.parseJsonObject(this._additionalFieldsJson).entrySet()) {
                this._additionalFields.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        return this._additionalFields;
    }

    public void setAdditionalFields(String additionalFields) {
        this._additionalFieldsJson = additionalFields;
    }

    public Map<String, Object> getDefaultFields() {
        if (null != this._defaultFieldsJson) {
            this._defaultFields.clear();
            this._defaultFields.putAll(this.parseJsonObject(this._defaultFieldsJson));
        }
        return this._defaultFields;
    }

    public void setDefaultFields(String additionalData) {
        this._defaultFieldsJson = additionalData;
    }

    private Map<String, Object> parseJsonObject(String additionalFields) {
        return this.getCodec().fromJson(additionalFields, Map.class);
    }

    protected final JsonCodec getCodec() {
        if (null == this._codec) {
            try {
                this._codec = (JsonCodec)Class.forName(this._codecClass).newInstance();
            }
            catch (Exception e) {
                this._codec = new SimpleJsonCodec();
            }
        }
        return this._codec;
    }
}

